// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the input of a `BatchGetItem` operation.
 */
public class BatchGetItemRequest private constructor(builder: Builder) {
    /**
     * A map of one or more table names and, for each table, a map that describes one or more items to retrieve from that table. Each table name can be used only once per `BatchGetItem` request.
     *
     * Each element in the map of items to retrieve consists of the following:
     * + `ConsistentRead` - If `true`, a strongly consistent read is used; if `false` (the default), an eventually consistent read is used.
     * + `ExpressionAttributeNames` - One or more substitution tokens for attribute names in the `ProjectionExpression` parameter. The following are some use cases for using `ExpressionAttributeNames`:
     *    + To access an attribute whose name conflicts with a DynamoDB reserved word.
     *    + To create a placeholder for repeating occurrences of an attribute name in an expression.
     *    + To prevent special characters in an attribute name from being misinterpreted in an expression.
     * Use the **#** character in an expression to dereference an attribute name. For example, consider the following attribute name:
     *    + `Percentile`
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*). To work around this, you could specify the following for `ExpressionAttributeNames`:
     *    + `{"#P":"Percentile"}`
     * You could then use this substitution in an expression, as in this example:
     *    + `#P = :val`
     * Tokens that begin with the **:** character are *expression attribute values*, which are placeholders for the actual value at runtime.For more information about expression attribute names, see [Accessing Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
     * + `Keys` - An array of primary key attribute values that define specific items in the table. For each primary key, you must provide *all* of the key attributes. For example, with a simple primary key, you only need to provide the partition key value. For a composite key, you must provide *both* the partition key value and the sort key value.
     * + `ProjectionExpression` - A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.For more information, see [Accessing Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
     * + `AttributesToGet` - This is a legacy parameter. Use `ProjectionExpression` instead. For more information, see [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val requestItems: Map<String, KeysAndAttributes>? = builder.requestItems
    /**
     * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:
     * + `INDEXES` - The response includes the aggregate `ConsumedCapacity` for the operation, together with `ConsumedCapacity` for each table and secondary index that was accessed.Note that some operations, such as `GetItem` and `BatchGetItem`, do not access any indexes at all. In these cases, specifying `INDEXES` will only return `ConsumedCapacity` information for table(s).
     * + `TOTAL` - The response includes only the aggregate `ConsumedCapacity` for the operation.
     * + `NONE` - No `ConsumedCapacity` details are included in the response.
     */
    public val returnConsumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity? = builder.returnConsumedCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.BatchGetItemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetItemRequest(")
        append("requestItems=$requestItems,")
        append("returnConsumedCapacity=$returnConsumedCapacity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = requestItems?.hashCode() ?: 0
        result = 31 * result + (returnConsumedCapacity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchGetItemRequest

        if (requestItems != other.requestItems) return false
        if (returnConsumedCapacity != other.returnConsumedCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.BatchGetItemRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map of one or more table names and, for each table, a map that describes one or more items to retrieve from that table. Each table name can be used only once per `BatchGetItem` request.
         *
         * Each element in the map of items to retrieve consists of the following:
         * + `ConsistentRead` - If `true`, a strongly consistent read is used; if `false` (the default), an eventually consistent read is used.
         * + `ExpressionAttributeNames` - One or more substitution tokens for attribute names in the `ProjectionExpression` parameter. The following are some use cases for using `ExpressionAttributeNames`:
         *    + To access an attribute whose name conflicts with a DynamoDB reserved word.
         *    + To create a placeholder for repeating occurrences of an attribute name in an expression.
         *    + To prevent special characters in an attribute name from being misinterpreted in an expression.
         * Use the **#** character in an expression to dereference an attribute name. For example, consider the following attribute name:
         *    + `Percentile`
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*). To work around this, you could specify the following for `ExpressionAttributeNames`:
         *    + `{"#P":"Percentile"}`
         * You could then use this substitution in an expression, as in this example:
         *    + `#P = :val`
         * Tokens that begin with the **:** character are *expression attribute values*, which are placeholders for the actual value at runtime.For more information about expression attribute names, see [Accessing Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
         * + `Keys` - An array of primary key attribute values that define specific items in the table. For each primary key, you must provide *all* of the key attributes. For example, with a simple primary key, you only need to provide the partition key value. For a composite key, you must provide *both* the partition key value and the sort key value.
         * + `ProjectionExpression` - A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.For more information, see [Accessing Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
         * + `AttributesToGet` - This is a legacy parameter. Use `ProjectionExpression` instead. For more information, see [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var requestItems: Map<String, KeysAndAttributes>? = null
        /**
         * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:
         * + `INDEXES` - The response includes the aggregate `ConsumedCapacity` for the operation, together with `ConsumedCapacity` for each table and secondary index that was accessed.Note that some operations, such as `GetItem` and `BatchGetItem`, do not access any indexes at all. In these cases, specifying `INDEXES` will only return `ConsumedCapacity` information for table(s).
         * + `TOTAL` - The response includes only the aggregate `ConsumedCapacity` for the operation.
         * + `NONE` - No `ConsumedCapacity` details are included in the response.
         */
        public var returnConsumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.BatchGetItemRequest) : this() {
            this.requestItems = x.requestItems
            this.returnConsumedCapacity = x.returnConsumedCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.BatchGetItemRequest = BatchGetItemRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
