// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details for the backup.
 */
public class BackupSummary private constructor(builder: Builder) {
    /**
     * ARN associated with the backup.
     */
    public val backupArn: kotlin.String? = builder.backupArn
    /**
     * Time at which the backup was created.
     */
    public val backupCreationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.backupCreationDateTime
    /**
     * Time at which the automatic on-demand backup created by DynamoDB will expire. This `SYSTEM` on-demand backup expires automatically 35 days after its creation.
     */
    public val backupExpiryDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.backupExpiryDateTime
    /**
     * Name of the specified backup.
     */
    public val backupName: kotlin.String? = builder.backupName
    /**
     * Size of the backup in bytes.
     */
    public val backupSizeBytes: kotlin.Long? = builder.backupSizeBytes
    /**
     * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
     */
    public val backupStatus: aws.sdk.kotlin.services.dynamodb.model.BackupStatus? = builder.backupStatus
    /**
     * BackupType:
     * + `USER` - You create and manage these using the on-demand backup feature.
     * + `SYSTEM` - If you delete a table with point-in-time recovery enabled, a `SYSTEM` backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion.
     * + `AWS_BACKUP` - On-demand backup created by you from Backup service.
     */
    public val backupType: aws.sdk.kotlin.services.dynamodb.model.BackupType? = builder.backupType
    /**
     * ARN associated with the table.
     */
    public val tableArn: kotlin.String? = builder.tableArn
    /**
     * Unique identifier for the table.
     */
    public val tableId: kotlin.String? = builder.tableId
    /**
     * Name of the table.
     */
    public val tableName: kotlin.String? = builder.tableName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.BackupSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupSummary(")
        append("backupArn=$backupArn,")
        append("backupCreationDateTime=$backupCreationDateTime,")
        append("backupExpiryDateTime=$backupExpiryDateTime,")
        append("backupName=$backupName,")
        append("backupSizeBytes=$backupSizeBytes,")
        append("backupStatus=$backupStatus,")
        append("backupType=$backupType,")
        append("tableArn=$tableArn,")
        append("tableId=$tableId,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupArn?.hashCode() ?: 0
        result = 31 * result + (backupCreationDateTime?.hashCode() ?: 0)
        result = 31 * result + (backupExpiryDateTime?.hashCode() ?: 0)
        result = 31 * result + (backupName?.hashCode() ?: 0)
        result = 31 * result + (backupSizeBytes?.hashCode() ?: 0)
        result = 31 * result + (backupStatus?.hashCode() ?: 0)
        result = 31 * result + (backupType?.hashCode() ?: 0)
        result = 31 * result + (tableArn?.hashCode() ?: 0)
        result = 31 * result + (tableId?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupSummary

        if (backupArn != other.backupArn) return false
        if (backupCreationDateTime != other.backupCreationDateTime) return false
        if (backupExpiryDateTime != other.backupExpiryDateTime) return false
        if (backupName != other.backupName) return false
        if (backupSizeBytes != other.backupSizeBytes) return false
        if (backupStatus != other.backupStatus) return false
        if (backupType != other.backupType) return false
        if (tableArn != other.tableArn) return false
        if (tableId != other.tableId) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.BackupSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ARN associated with the backup.
         */
        public var backupArn: kotlin.String? = null
        /**
         * Time at which the backup was created.
         */
        public var backupCreationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Time at which the automatic on-demand backup created by DynamoDB will expire. This `SYSTEM` on-demand backup expires automatically 35 days after its creation.
         */
        public var backupExpiryDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Name of the specified backup.
         */
        public var backupName: kotlin.String? = null
        /**
         * Size of the backup in bytes.
         */
        public var backupSizeBytes: kotlin.Long? = null
        /**
         * Backup can be in one of the following states: CREATING, ACTIVE, DELETED.
         */
        public var backupStatus: aws.sdk.kotlin.services.dynamodb.model.BackupStatus? = null
        /**
         * BackupType:
         * + `USER` - You create and manage these using the on-demand backup feature.
         * + `SYSTEM` - If you delete a table with point-in-time recovery enabled, a `SYSTEM` backup is automatically created and is retained for 35 days (at no additional cost). System backups allow you to restore the deleted table to the state it was in just before the point of deletion.
         * + `AWS_BACKUP` - On-demand backup created by you from Backup service.
         */
        public var backupType: aws.sdk.kotlin.services.dynamodb.model.BackupType? = null
        /**
         * ARN associated with the table.
         */
        public var tableArn: kotlin.String? = null
        /**
         * Unique identifier for the table.
         */
        public var tableId: kotlin.String? = null
        /**
         * Name of the table.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.BackupSummary) : this() {
            this.backupArn = x.backupArn
            this.backupCreationDateTime = x.backupCreationDateTime
            this.backupExpiryDateTime = x.backupExpiryDateTime
            this.backupName = x.backupName
            this.backupSizeBytes = x.backupSizeBytes
            this.backupStatus = x.backupStatus
            this.backupType = x.backupType
            this.tableArn = x.tableArn
            this.tableId = x.tableId
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.BackupSummary = BackupSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
