// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the auto scaling settings to be modified for a global table or global secondary index.
 */
public class AutoScalingSettingsUpdate private constructor(builder: Builder) {
    /**
     * Disabled auto scaling for this global table or global secondary index.
     */
    public val autoScalingDisabled: kotlin.Boolean? = builder.autoScalingDisabled
    /**
     * Role ARN used for configuring auto scaling policy.
     */
    public val autoScalingRoleArn: kotlin.String? = builder.autoScalingRoleArn
    /**
     * The maximum capacity units that a global table or global secondary index should be scaled up to.
     */
    public val maximumUnits: kotlin.Long? = builder.maximumUnits
    /**
     * The minimum capacity units that a global table or global secondary index should be scaled down to.
     */
    public val minimumUnits: kotlin.Long? = builder.minimumUnits
    /**
     * The scaling policy to apply for scaling target global table or global secondary index capacity units.
     */
    public val scalingPolicyUpdate: aws.sdk.kotlin.services.dynamodb.model.AutoScalingPolicyUpdate? = builder.scalingPolicyUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingSettingsUpdate(")
        append("autoScalingDisabled=$autoScalingDisabled,")
        append("autoScalingRoleArn=$autoScalingRoleArn,")
        append("maximumUnits=$maximumUnits,")
        append("minimumUnits=$minimumUnits,")
        append("scalingPolicyUpdate=$scalingPolicyUpdate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoScalingDisabled?.hashCode() ?: 0
        result = 31 * result + (autoScalingRoleArn?.hashCode() ?: 0)
        result = 31 * result + (maximumUnits?.hashCode() ?: 0)
        result = 31 * result + (minimumUnits?.hashCode() ?: 0)
        result = 31 * result + (scalingPolicyUpdate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingSettingsUpdate

        if (autoScalingDisabled != other.autoScalingDisabled) return false
        if (autoScalingRoleArn != other.autoScalingRoleArn) return false
        if (maximumUnits != other.maximumUnits) return false
        if (minimumUnits != other.minimumUnits) return false
        if (scalingPolicyUpdate != other.scalingPolicyUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Disabled auto scaling for this global table or global secondary index.
         */
        public var autoScalingDisabled: kotlin.Boolean? = null
        /**
         * Role ARN used for configuring auto scaling policy.
         */
        public var autoScalingRoleArn: kotlin.String? = null
        /**
         * The maximum capacity units that a global table or global secondary index should be scaled up to.
         */
        public var maximumUnits: kotlin.Long? = null
        /**
         * The minimum capacity units that a global table or global secondary index should be scaled down to.
         */
        public var minimumUnits: kotlin.Long? = null
        /**
         * The scaling policy to apply for scaling target global table or global secondary index capacity units.
         */
        public var scalingPolicyUpdate: aws.sdk.kotlin.services.dynamodb.model.AutoScalingPolicyUpdate? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate) : this() {
            this.autoScalingDisabled = x.autoScalingDisabled
            this.autoScalingRoleArn = x.autoScalingRoleArn
            this.maximumUnits = x.maximumUnits
            this.minimumUnits = x.minimumUnits
            this.scalingPolicyUpdate = x.scalingPolicyUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate = AutoScalingSettingsUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.AutoScalingPolicyUpdate] inside the given [block]
         */
        public fun scalingPolicyUpdate(block: aws.sdk.kotlin.services.dynamodb.model.AutoScalingPolicyUpdate.Builder.() -> kotlin.Unit) {
            this.scalingPolicyUpdate = aws.sdk.kotlin.services.dynamodb.model.AutoScalingPolicyUpdate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
