// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.serde

import aws.sdk.kotlin.services.dynamodb.model.AttributeValue
import aws.sdk.kotlin.services.dynamodb.model.Condition
import aws.sdk.kotlin.services.dynamodb.model.ConditionalOperator
import aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.ScanRequest
import aws.sdk.kotlin.services.dynamodb.model.Select
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ScanOperationSerializer: HttpSerialize<ScanRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ScanRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeScanOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.0")
        }
        return builder
    }
}

private fun serializeScanOperationBody(context: ExecutionContext, input: ScanRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTESTOGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AttributesToGet"))
    val CONDITIONALOPERATOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ConditionalOperator"))
    val CONSISTENTREAD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("ConsistentRead"))
    val EXCLUSIVESTARTKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ExclusiveStartKey"))
    val EXPRESSIONATTRIBUTENAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ExpressionAttributeNames"))
    val EXPRESSIONATTRIBUTEVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ExpressionAttributeValues"))
    val FILTEREXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FilterExpression"))
    val INDEXNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IndexName"))
    val LIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Limit"))
    val PROJECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProjectionExpression"))
    val RETURNCONSUMEDCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ReturnConsumedCapacity"))
    val SCANFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ScanFilter"))
    val SEGMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Segment"))
    val SELECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Select"))
    val TABLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TableName"))
    val TOTALSEGMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TotalSegments"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTESTOGET_DESCRIPTOR)
        field(CONDITIONALOPERATOR_DESCRIPTOR)
        field(CONSISTENTREAD_DESCRIPTOR)
        field(EXCLUSIVESTARTKEY_DESCRIPTOR)
        field(EXPRESSIONATTRIBUTENAMES_DESCRIPTOR)
        field(EXPRESSIONATTRIBUTEVALUES_DESCRIPTOR)
        field(FILTEREXPRESSION_DESCRIPTOR)
        field(INDEXNAME_DESCRIPTOR)
        field(LIMIT_DESCRIPTOR)
        field(PROJECTIONEXPRESSION_DESCRIPTOR)
        field(RETURNCONSUMEDCAPACITY_DESCRIPTOR)
        field(SCANFILTER_DESCRIPTOR)
        field(SEGMENT_DESCRIPTOR)
        field(SELECT_DESCRIPTOR)
        field(TABLENAME_DESCRIPTOR)
        field(TOTALSEGMENTS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.attributesToGet != null) {
            listField(ATTRIBUTESTOGET_DESCRIPTOR) {
                for (el0 in input.attributesToGet) {
                    serializeString(el0)
                }
            }
        }
        input.conditionalOperator?.let { field(CONDITIONALOPERATOR_DESCRIPTOR, it.value) }
        input.consistentRead?.let { field(CONSISTENTREAD_DESCRIPTOR, it) }
        if (input.exclusiveStartKey != null) {
            mapField(EXCLUSIVESTARTKEY_DESCRIPTOR) {
                input.exclusiveStartKey.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeAttributeValueDocument)) }
            }
        }
        if (input.expressionAttributeNames != null) {
            mapField(EXPRESSIONATTRIBUTENAMES_DESCRIPTOR) {
                input.expressionAttributeNames.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.expressionAttributeValues != null) {
            mapField(EXPRESSIONATTRIBUTEVALUES_DESCRIPTOR) {
                input.expressionAttributeValues.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeAttributeValueDocument)) }
            }
        }
        input.filterExpression?.let { field(FILTEREXPRESSION_DESCRIPTOR, it) }
        input.indexName?.let { field(INDEXNAME_DESCRIPTOR, it) }
        input.limit?.let { field(LIMIT_DESCRIPTOR, it) }
        input.projectionExpression?.let { field(PROJECTIONEXPRESSION_DESCRIPTOR, it) }
        input.returnConsumedCapacity?.let { field(RETURNCONSUMEDCAPACITY_DESCRIPTOR, it.value) }
        if (input.scanFilter != null) {
            mapField(SCANFILTER_DESCRIPTOR) {
                input.scanFilter.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeConditionDocument)) }
            }
        }
        input.segment?.let { field(SEGMENT_DESCRIPTOR, it) }
        input.select?.let { field(SELECT_DESCRIPTOR, it.value) }
        input.tableName?.let { field(TABLENAME_DESCRIPTOR, it) }
        input.totalSegments?.let { field(TOTALSEGMENTS_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
