// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.serde

import aws.sdk.kotlin.services.dynamodb.model.ImportTableRequest
import aws.sdk.kotlin.services.dynamodb.model.InputCompressionType
import aws.sdk.kotlin.services.dynamodb.model.InputFormat
import aws.sdk.kotlin.services.dynamodb.model.InputFormatOptions
import aws.sdk.kotlin.services.dynamodb.model.S3BucketSource
import aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportTableOperationSerializer: HttpSerialize<ImportTableRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ImportTableRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeImportTableOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.0")
        }
        return builder
    }
}

private fun serializeImportTableOperationBody(context: ExecutionContext, input: ImportTableRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val INPUTCOMPRESSIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("InputCompressionType"))
    val INPUTFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("InputFormat"))
    val INPUTFORMATOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputFormatOptions"))
    val S3BUCKETSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("S3BucketSource"))
    val TABLECREATIONPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TableCreationParameters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(INPUTCOMPRESSIONTYPE_DESCRIPTOR)
        field(INPUTFORMAT_DESCRIPTOR)
        field(INPUTFORMATOPTIONS_DESCRIPTOR)
        field(S3BUCKETSOURCE_DESCRIPTOR)
        field(TABLECREATIONPARAMETERS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.inputCompressionType?.let { field(INPUTCOMPRESSIONTYPE_DESCRIPTOR, it.value) }
        input.inputFormat?.let { field(INPUTFORMAT_DESCRIPTOR, it.value) }
        input.inputFormatOptions?.let { field(INPUTFORMATOPTIONS_DESCRIPTOR, it, ::serializeInputFormatOptionsDocument) }
        input.s3BucketSource?.let { field(S3BUCKETSOURCE_DESCRIPTOR, it, ::serializeS3BucketSourceDocument) }
        input.tableCreationParameters?.let { field(TABLECREATIONPARAMETERS_DESCRIPTOR, it, ::serializeTableCreationParametersDocument) }
    }
    return serializer.toByteArray()
}
