// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.serde

import aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.DynamoDbException
import aws.sdk.kotlin.services.dynamodb.model.ExecuteTransactionResponse
import aws.sdk.kotlin.services.dynamodb.model.ItemResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ExecuteTransactionOperationDeserializer: HttpDeserialize<ExecuteTransactionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ExecuteTransactionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwExecuteTransactionError(context, call)
        }
        val builder = ExecuteTransactionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeExecuteTransactionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwExecuteTransactionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DynamoDbException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "IdempotentParameterMismatchException" -> IdempotentParameterMismatchExceptionDeserializer().deserialize(context, wrappedCall)
        "TransactionCanceledException" -> TransactionCanceledExceptionDeserializer().deserialize(context, wrappedCall)
        "RequestLimitExceeded" -> RequestLimitExceededDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "TransactionInProgressException" -> TransactionInProgressExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DynamoDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeExecuteTransactionOperationBody(builder: ExecuteTransactionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONSUMEDCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ConsumedCapacity"))
    val RESPONSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Responses"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONSUMEDCAPACITY_DESCRIPTOR)
        field(RESPONSES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONSUMEDCAPACITY_DESCRIPTOR.index -> builder.consumedCapacity =
                    deserializer.deserializeList(CONSUMEDCAPACITY_DESCRIPTOR) {
                        val col0 = mutableListOf<ConsumedCapacity>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConsumedCapacityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESPONSES_DESCRIPTOR.index -> builder.responses =
                    deserializer.deserializeList(RESPONSES_DESCRIPTOR) {
                        val col0 = mutableListOf<ItemResponse>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeItemResponseDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
