// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.serde

import aws.sdk.kotlin.services.dynamodb.model.AttributeValue
import aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.DynamoDbException
import aws.sdk.kotlin.services.dynamodb.model.ExecuteStatementResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class ExecuteStatementOperationDeserializer: HttpDeserialize<ExecuteStatementResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ExecuteStatementResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwExecuteStatementError(context, call)
        }
        val builder = ExecuteStatementResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeExecuteStatementOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwExecuteStatementError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DynamoDbException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "DuplicateItemException" -> DuplicateItemExceptionDeserializer().deserialize(context, wrappedCall)
        "RequestLimitExceeded" -> RequestLimitExceededDeserializer().deserialize(context, wrappedCall)
        "TransactionConflictException" -> TransactionConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ConditionalCheckFailedException" -> ConditionalCheckFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "ItemCollectionSizeLimitExceededException" -> ItemCollectionSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DynamoDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeExecuteStatementOperationBody(builder: ExecuteStatementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONSUMEDCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ConsumedCapacity"))
    val ITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Items"))
    val ITEMS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val LASTEVALUATEDKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("LastEvaluatedKey"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONSUMEDCAPACITY_DESCRIPTOR)
        field(ITEMS_DESCRIPTOR)
        field(LASTEVALUATEDKEY_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONSUMEDCAPACITY_DESCRIPTOR.index -> builder.consumedCapacity = deserializeConsumedCapacityDocument(deserializer)
                ITEMS_DESCRIPTOR.index -> builder.items =
                    deserializer.deserializeList(ITEMS_DESCRIPTOR) {
                        val col0 = mutableListOf<Map<String, AttributeValue>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeMap(ITEMS_C0_DESCRIPTOR) {
                                val map1 = mutableMapOf<String, AttributeValue>()
                                while (hasNextEntry()) {
                                    val k1 = key()
                                    val v1 = if (nextHasValue()) { deserializeAttributeValueDocument(deserializer) } else { deserializeNull(); continue }
                                    map1[k1] = v1
                                }
                                map1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTEVALUATEDKEY_DESCRIPTOR.index -> builder.lastEvaluatedKey =
                    deserializer.deserializeMap(LASTEVALUATEDKEY_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, AttributeValue>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeAttributeValueDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
