// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.serde

import aws.sdk.kotlin.services.dynamodb.model.BatchWriteItemResponse
import aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.DynamoDbException
import aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics
import aws.sdk.kotlin.services.dynamodb.model.WriteRequest
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class BatchWriteItemOperationDeserializer: HttpDeserialize<BatchWriteItemResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): BatchWriteItemResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchWriteItemError(context, call)
        }
        val builder = BatchWriteItemResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchWriteItemOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwBatchWriteItemError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DynamoDbException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidEndpointException" -> InvalidEndpointExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "RequestLimitExceeded" -> RequestLimitExceededDeserializer().deserialize(context, wrappedCall)
        "ItemCollectionSizeLimitExceededException" -> ItemCollectionSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DynamoDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchWriteItemOperationBody(builder: BatchWriteItemResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONSUMEDCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ConsumedCapacity"))
    val ITEMCOLLECTIONMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ItemCollectionMetrics"))
    val ITEMCOLLECTIONMETRICS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val UNPROCESSEDITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("UnprocessedItems"))
    val UNPROCESSEDITEMS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONSUMEDCAPACITY_DESCRIPTOR)
        field(ITEMCOLLECTIONMETRICS_DESCRIPTOR)
        field(UNPROCESSEDITEMS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONSUMEDCAPACITY_DESCRIPTOR.index -> builder.consumedCapacity =
                    deserializer.deserializeList(CONSUMEDCAPACITY_DESCRIPTOR) {
                        val col0 = mutableListOf<ConsumedCapacity>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConsumedCapacityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ITEMCOLLECTIONMETRICS_DESCRIPTOR.index -> builder.itemCollectionMetrics =
                    deserializer.deserializeMap(ITEMCOLLECTIONMETRICS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<ItemCollectionMetrics>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(ITEMCOLLECTIONMETRICS_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<ItemCollectionMetrics>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeItemCollectionMetricsDocument(deserializer) } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                UNPROCESSEDITEMS_DESCRIPTOR.index -> builder.unprocessedItems =
                    deserializer.deserializeMap(UNPROCESSEDITEMS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<WriteRequest>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(UNPROCESSEDITEMS_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<WriteRequest>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeWriteRequestDocument(deserializer) } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
