// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.paginators

import aws.sdk.kotlin.services.dynamodb.DynamoDbClient
import aws.sdk.kotlin.services.dynamodb.model.AttributeValue
import aws.sdk.kotlin.services.dynamodb.model.ListContributorInsightsRequest
import aws.sdk.kotlin.services.dynamodb.model.ListContributorInsightsResponse
import aws.sdk.kotlin.services.dynamodb.model.ListExportsRequest
import aws.sdk.kotlin.services.dynamodb.model.ListExportsResponse
import aws.sdk.kotlin.services.dynamodb.model.ListImportsRequest
import aws.sdk.kotlin.services.dynamodb.model.ListImportsResponse
import aws.sdk.kotlin.services.dynamodb.model.ListTablesRequest
import aws.sdk.kotlin.services.dynamodb.model.ListTablesResponse
import aws.sdk.kotlin.services.dynamodb.model.QueryRequest
import aws.sdk.kotlin.services.dynamodb.model.QueryResponse
import aws.sdk.kotlin.services.dynamodb.model.ScanRequest
import aws.sdk.kotlin.services.dynamodb.model.ScanResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListContributorInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContributorInsightsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContributorInsightsResponse]
 */
public fun DynamoDbClient.listContributorInsightsPaginated(initialRequest: ListContributorInsightsRequest = ListContributorInsightsRequest { }): Flow<ListContributorInsightsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContributorInsightsPaginated.listContributorInsights(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListContributorInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContributorInsightsResponse]
 */
public fun DynamoDbClient.listContributorInsightsPaginated(block: ListContributorInsightsRequest.Builder.() -> Unit): Flow<ListContributorInsightsResponse> =
    listContributorInsightsPaginated(ListContributorInsightsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExportsResponse]
 */
public fun DynamoDbClient.listExportsPaginated(initialRequest: ListExportsRequest = ListExportsRequest { }): Flow<ListExportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExportsPaginated.listExports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExportsResponse]
 */
public fun DynamoDbClient.listExportsPaginated(block: ListExportsRequest.Builder.() -> Unit): Flow<ListExportsResponse> =
    listExportsPaginated(ListExportsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListImportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportsResponse]
 */
public fun DynamoDbClient.listImportsPaginated(initialRequest: ListImportsRequest = ListImportsRequest { }): Flow<ListImportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImportsPaginated.listImports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportsResponse]
 */
public fun DynamoDbClient.listImportsPaginated(block: ListImportsRequest.Builder.() -> Unit): Flow<ListImportsResponse> =
    listImportsPaginated(ListImportsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTablesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
public fun DynamoDbClient.listTablesPaginated(initialRequest: ListTablesRequest = ListTablesRequest { }): Flow<ListTablesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.exclusiveStartTableName = cursor
            }
            val result = this@listTablesPaginated.listTables(req)
            cursor = result.lastEvaluatedTableName
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
public fun DynamoDbClient.listTablesPaginated(block: ListTablesRequest.Builder.() -> Unit): Flow<ListTablesResponse> =
    listTablesPaginated(ListTablesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTablesPaginated]
 * to access the nested member [TableName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TableName]
 */
@JvmName("listTablesResponseTableName")
public fun Flow<ListTablesResponse>.tableNames(): Flow<String> =
    transform() { response ->
        response.tableNames?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [QueryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [QueryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueryResponse]
 */
public fun DynamoDbClient.queryPaginated(initialRequest: QueryRequest): Flow<QueryResponse> =
    flow {
        var cursor: Map<String, AttributeValue>? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.exclusiveStartKey = cursor
            }
            val result = this@queryPaginated.query(req)
            cursor = result.lastEvaluatedKey
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [QueryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [QueryResponse]
 */
public fun DynamoDbClient.queryPaginated(block: QueryRequest.Builder.() -> Unit): Flow<QueryResponse> =
    queryPaginated(QueryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [queryPaginated]
 * to access the nested member [AttributeMap]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AttributeMap]
 */
@JvmName("queryResponseAttributeMap")
public fun Flow<QueryResponse>.items(): Flow<Map<String, AttributeValue>> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ScanResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ScanRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScanResponse]
 */
public fun DynamoDbClient.scanPaginated(initialRequest: ScanRequest): Flow<ScanResponse> =
    flow {
        var cursor: Map<String, AttributeValue>? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.exclusiveStartKey = cursor
            }
            val result = this@scanPaginated.scan(req)
            cursor = result.lastEvaluatedKey
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ScanResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScanResponse]
 */
public fun DynamoDbClient.scanPaginated(block: ScanRequest.Builder.() -> Unit): Flow<ScanResponse> =
    scanPaginated(ScanRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [scanPaginated]
 * to access the nested member [AttributeMap]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AttributeMap]
 */
@JvmName("scanResponseAttributeMap")
public fun Flow<ScanResponse>.items(): Flow<Map<String, AttributeValue>> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
