// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the input of an `UpdateTable` operation.
 */
public class UpdateTableRequest private constructor(builder: Builder) {
    /**
     * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global secondary index to the table, `AttributeDefinitions` must include the key element(s) of the new index.
     */
    public val attributeDefinitions: List<AttributeDefinition>? = builder.attributeDefinitions
    /**
     * Controls how you are charged for read and write throughput and how you manage capacity. When switching from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial provisioned capacity values are estimated based on the consumed read and write capacity of your table and global secondary indexes over the past 30 minutes.
     * + `PROVISIONED` - We recommend using `PROVISIONED` for predictable workloads. `PROVISIONED` sets the billing mode to [Provisioned Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual).
     * + `PAY_PER_REQUEST` - We recommend using `PAY_PER_REQUEST` for unpredictable workloads. `PAY_PER_REQUEST` sets the billing mode to [On-Demand Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand).
     */
    public val billingMode: aws.sdk.kotlin.services.dynamodb.model.BillingMode? = builder.billingMode
    /**
     * Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
     */
    public val deletionProtectionEnabled: kotlin.Boolean? = builder.deletionProtectionEnabled
    /**
     * An array of one or more global secondary indexes for the table. For each index in the array, you can request one action:
     * + `Create` - add a new global secondary index to the table.
     * + `Update` - modify the provisioned throughput settings of an existing global secondary index.
     * + `Delete` - remove a global secondary index from the table.
     *
     * You can create or delete only one global secondary index per `UpdateTable` operation.
     *
     * For more information, see [Managing Global Secondary Indexes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val globalSecondaryIndexUpdates: List<GlobalSecondaryIndexUpdate>? = builder.globalSecondaryIndexUpdates
    /**
     * The new provisioned throughput settings for the specified table or index.
     */
    public val provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput? = builder.provisionedThroughput
    /**
     * A list of replica update actions (create, delete, or update) for the table.
     *
     * This property only applies to [Version 2019.11.21 (Current)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) of global tables.
     */
    public val replicaUpdates: List<ReplicationGroupUpdate>? = builder.replicaUpdates
    /**
     * The new server-side encryption settings for the specified table.
     */
    public val sseSpecification: aws.sdk.kotlin.services.dynamodb.model.SseSpecification? = builder.sseSpecification
    /**
     * Represents the DynamoDB Streams configuration for the table.
     *
     * You receive a `ResourceInUseException` if you try to enable a stream on a table that already has a stream, or if you try to disable a stream on a table that doesn't have a stream.
     */
    public val streamSpecification: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification? = builder.streamSpecification
    /**
     * The table class of the table to be updated. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
     */
    public val tableClass: aws.sdk.kotlin.services.dynamodb.model.TableClass? = builder.tableClass
    /**
     * The name of the table to be updated.
     */
    public val tableName: kotlin.String? = builder.tableName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.UpdateTableRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTableRequest(")
        append("attributeDefinitions=$attributeDefinitions,")
        append("billingMode=$billingMode,")
        append("deletionProtectionEnabled=$deletionProtectionEnabled,")
        append("globalSecondaryIndexUpdates=$globalSecondaryIndexUpdates,")
        append("provisionedThroughput=$provisionedThroughput,")
        append("replicaUpdates=$replicaUpdates,")
        append("sseSpecification=$sseSpecification,")
        append("streamSpecification=$streamSpecification,")
        append("tableClass=$tableClass,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeDefinitions?.hashCode() ?: 0
        result = 31 * result + (billingMode?.hashCode() ?: 0)
        result = 31 * result + (deletionProtectionEnabled?.hashCode() ?: 0)
        result = 31 * result + (globalSecondaryIndexUpdates?.hashCode() ?: 0)
        result = 31 * result + (provisionedThroughput?.hashCode() ?: 0)
        result = 31 * result + (replicaUpdates?.hashCode() ?: 0)
        result = 31 * result + (sseSpecification?.hashCode() ?: 0)
        result = 31 * result + (streamSpecification?.hashCode() ?: 0)
        result = 31 * result + (tableClass?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTableRequest

        if (attributeDefinitions != other.attributeDefinitions) return false
        if (billingMode != other.billingMode) return false
        if (deletionProtectionEnabled != other.deletionProtectionEnabled) return false
        if (globalSecondaryIndexUpdates != other.globalSecondaryIndexUpdates) return false
        if (provisionedThroughput != other.provisionedThroughput) return false
        if (replicaUpdates != other.replicaUpdates) return false
        if (sseSpecification != other.sseSpecification) return false
        if (streamSpecification != other.streamSpecification) return false
        if (tableClass != other.tableClass) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.UpdateTableRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global secondary index to the table, `AttributeDefinitions` must include the key element(s) of the new index.
         */
        public var attributeDefinitions: List<AttributeDefinition>? = null
        /**
         * Controls how you are charged for read and write throughput and how you manage capacity. When switching from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial provisioned capacity values are estimated based on the consumed read and write capacity of your table and global secondary indexes over the past 30 minutes.
         * + `PROVISIONED` - We recommend using `PROVISIONED` for predictable workloads. `PROVISIONED` sets the billing mode to [Provisioned Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual).
         * + `PAY_PER_REQUEST` - We recommend using `PAY_PER_REQUEST` for unpredictable workloads. `PAY_PER_REQUEST` sets the billing mode to [On-Demand Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand).
         */
        public var billingMode: aws.sdk.kotlin.services.dynamodb.model.BillingMode? = null
        /**
         * Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
         */
        public var deletionProtectionEnabled: kotlin.Boolean? = null
        /**
         * An array of one or more global secondary indexes for the table. For each index in the array, you can request one action:
         * + `Create` - add a new global secondary index to the table.
         * + `Update` - modify the provisioned throughput settings of an existing global secondary index.
         * + `Delete` - remove a global secondary index from the table.
         *
         * You can create or delete only one global secondary index per `UpdateTable` operation.
         *
         * For more information, see [Managing Global Secondary Indexes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var globalSecondaryIndexUpdates: List<GlobalSecondaryIndexUpdate>? = null
        /**
         * The new provisioned throughput settings for the specified table or index.
         */
        public var provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput? = null
        /**
         * A list of replica update actions (create, delete, or update) for the table.
         *
         * This property only applies to [Version 2019.11.21 (Current)](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html) of global tables.
         */
        public var replicaUpdates: List<ReplicationGroupUpdate>? = null
        /**
         * The new server-side encryption settings for the specified table.
         */
        public var sseSpecification: aws.sdk.kotlin.services.dynamodb.model.SseSpecification? = null
        /**
         * Represents the DynamoDB Streams configuration for the table.
         *
         * You receive a `ResourceInUseException` if you try to enable a stream on a table that already has a stream, or if you try to disable a stream on a table that doesn't have a stream.
         */
        public var streamSpecification: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification? = null
        /**
         * The table class of the table to be updated. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
         */
        public var tableClass: aws.sdk.kotlin.services.dynamodb.model.TableClass? = null
        /**
         * The name of the table to be updated.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.UpdateTableRequest) : this() {
            this.attributeDefinitions = x.attributeDefinitions
            this.billingMode = x.billingMode
            this.deletionProtectionEnabled = x.deletionProtectionEnabled
            this.globalSecondaryIndexUpdates = x.globalSecondaryIndexUpdates
            this.provisionedThroughput = x.provisionedThroughput
            this.replicaUpdates = x.replicaUpdates
            this.sseSpecification = x.sseSpecification
            this.streamSpecification = x.streamSpecification
            this.tableClass = x.tableClass
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.UpdateTableRequest = UpdateTableRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput] inside the given [block]
         */
        public fun provisionedThroughput(block: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput.Builder.() -> kotlin.Unit) {
            this.provisionedThroughput = aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.SseSpecification] inside the given [block]
         */
        public fun sseSpecification(block: aws.sdk.kotlin.services.dynamodb.model.SseSpecification.Builder.() -> kotlin.Unit) {
            this.sseSpecification = aws.sdk.kotlin.services.dynamodb.model.SseSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.StreamSpecification] inside the given [block]
         */
        public fun streamSpecification(block: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification.Builder.() -> kotlin.Unit) {
            this.streamSpecification = aws.sdk.kotlin.services.dynamodb.model.StreamSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
