// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the input of an `UpdateItem` operation.
 */
public class UpdateItemRequest private constructor(builder: Builder) {
    /**
     * This is a legacy parameter. Use `UpdateExpression` instead. For more information, see [AttributeUpdates](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val attributeUpdates: Map<String, AttributeValueUpdate>? = builder.attributeUpdates
    /**
     * A condition that must be satisfied in order for a conditional update to succeed.
     *
     * An expression can contain any of the following:
     * + Functions: `attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size`These function names are case-sensitive.
     * + Comparison operators: `= | <> | < | > | <= | >= | BETWEEN | IN `
     * +  Logical operators: `AND | OR | NOT`
     *
     * For more information about condition expressions, see [Specifying Conditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val conditionExpression: kotlin.String? = builder.conditionExpression
    /**
     * This is a legacy parameter. Use `ConditionExpression` instead. For more information, see [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val conditionalOperator: aws.sdk.kotlin.services.dynamodb.model.ConditionalOperator? = builder.conditionalOperator
    /**
     * This is a legacy parameter. Use `ConditionExpression` instead. For more information, see [Expected](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val expected: Map<String, ExpectedAttributeValue>? = builder.expected
    /**
     * One or more substitution tokens for attribute names in an expression. The following are some use cases for using `ExpressionAttributeNames`:
     * + To access an attribute whose name conflicts with a DynamoDB reserved word.
     * + To create a placeholder for repeating occurrences of an attribute name in an expression.
     * + To prevent special characters in an attribute name from being misinterpreted in an expression.
     *
     * Use the **#** character in an expression to dereference an attribute name. For example, consider the following attribute name:
     * + `Percentile`
     *
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*.) To work around this, you could specify the following for `ExpressionAttributeNames`:
     * + `{"#P":"Percentile"}`
     *
     * You could then use this substitution in an expression, as in this example:
     * + `#P = :val`
     *
     * Tokens that begin with the **:** character are *expression attribute values*, which are placeholders for the actual value at runtime.
     *
     * For more information about expression attribute names, see [Specifying Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val expressionAttributeNames: Map<String, String>? = builder.expressionAttributeNames
    /**
     * One or more values that can be substituted in an expression.
     *
     * Use the **:** (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the `ProductStatus` attribute was one of the following:
     *
     * `Available | Backordered | Discontinued`
     *
     * You would first need to specify `ExpressionAttributeValues` as follows:
     *
     * `{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }`
     *
     * You could then use these values in an expression, such as this:
     *
     * `ProductStatus IN (:avail, :back, :disc)`
     *
     * For more information on expression attribute values, see [Condition Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val expressionAttributeValues: Map<String, AttributeValue>? = builder.expressionAttributeValues
    /**
     * The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.
     *
     * For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.
     */
    public val key: Map<String, AttributeValue>? = builder.key
    /**
     * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:
     * + `INDEXES` - The response includes the aggregate `ConsumedCapacity` for the operation, together with `ConsumedCapacity` for each table and secondary index that was accessed.Note that some operations, such as `GetItem` and `BatchGetItem`, do not access any indexes at all. In these cases, specifying `INDEXES` will only return `ConsumedCapacity` information for table(s).
     * + `TOTAL` - The response includes only the aggregate `ConsumedCapacity` for the operation.
     * + `NONE` - No `ConsumedCapacity` details are included in the response.
     */
    public val returnConsumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity? = builder.returnConsumedCapacity
    /**
     * Determines whether item collection metrics are returned. If set to `SIZE`, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to `NONE` (the default), no statistics are returned.
     */
    public val returnItemCollectionMetrics: aws.sdk.kotlin.services.dynamodb.model.ReturnItemCollectionMetrics? = builder.returnItemCollectionMetrics
    /**
     * Use `ReturnValues` if you want to get the item attributes as they appear before or after they are successfully updated. For `UpdateItem`, the valid values are:
     * + `NONE` - If `ReturnValues` is not specified, or if its value is `NONE`, then nothing is returned. (This setting is the default for `ReturnValues`.)
     * + `ALL_OLD` - Returns all of the attributes of the item, as they appeared before the UpdateItem operation.
     * + `UPDATED_OLD` - Returns only the updated attributes, as they appeared before the UpdateItem operation.
     * + `ALL_NEW` - Returns all of the attributes of the item, as they appear after the UpdateItem operation.
     * + `UPDATED_NEW` - Returns only the updated attributes, as they appear after the UpdateItem operation.
     *
     * There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.
     *
     * The values returned are strongly consistent.
     */
    public val returnValues: aws.sdk.kotlin.services.dynamodb.model.ReturnValue? = builder.returnValues
    /**
     * An optional parameter that returns the item attributes for an `UpdateItem` operation that failed a condition check.
     *
     * There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.
     */
    public val returnValuesOnConditionCheckFailure: aws.sdk.kotlin.services.dynamodb.model.ReturnValuesOnConditionCheckFailure? = builder.returnValuesOnConditionCheckFailure
    /**
     * The name of the table containing the item to update.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * An expression that defines one or more attributes to be updated, the action to be performed on them, and new values for them.
     *
     * The following action values are available for `UpdateExpression`.
     * + `SET` - Adds one or more attributes and values to an item. If any of these attributes already exist, they are replaced by the new values. You can also use `SET` to add or subtract from an attribute that is of type Number. For example: `SET myNum = myNum + :val``SET` supports the following functions:
     *    + `if_not_exists (path, operand)` - if the item does not contain an attribute at the specified path, then `if_not_exists` evaluates to operand; otherwise, it evaluates to path. You can use this function to avoid overwriting an attribute that may already be present in the item.
     *    + `list_append (operand, operand)` - evaluates to a list with a new element added to it. You can append the new element to the start or the end of the list by reversing the order of the operands.
     * These function names are case-sensitive.
     * + `REMOVE` - Removes one or more attributes from an item.
     * + `ADD` - Adds the specified value to the item, if the attribute does not already exist. If the attribute does exist, then the behavior of `ADD` depends on the data type of the attribute:
     *    + If the existing attribute is a number, and if `Value` is also a number, then `Value` is mathematically added to the existing attribute. If `Value` is a negative number, then it is subtracted from the existing attribute.If you use `ADD` to increment or decrement a number value for an item that doesn't exist before the update, DynamoDB uses `0` as the initial value.Similarly, if you use `ADD` for an existing item to increment or decrement an attribute value that doesn't exist before the update, DynamoDB uses `0` as the initial value. For example, suppose that the item you want to update doesn't have an attribute named `itemcount`, but you decide to `ADD` the number `3` to this attribute anyway. DynamoDB will create the `itemcount` attribute, set its initial value to `0`, and finally add `3` to it. The result will be a new `itemcount` attribute in the item, with a value of `3`.
     *    + If the existing data type is a set and if `Value` is also a set, then `Value` is added to the existing set. For example, if the attribute value is the set `[1,2]`, and the `ADD` action specified `[3]`, then the final attribute value is `[1,2,3]`. An error occurs if an `ADD` action is specified for a set attribute and the attribute type specified does not match the existing set type. Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the `Value` must also be a set of strings.
     * The `ADD` action only supports Number and set data types. In addition, `ADD` can only be used on top-level attributes, not nested attributes.
     * + `DELETE` - Deletes an element from a set.If a set of values is specified, then those values are subtracted from the old set. For example, if the attribute value was the set `[a,b,c]` and the `DELETE` action specifies `[a,c]`, then the final attribute value is `[b]`. Specifying an empty set is an error.The `DELETE` action only supports set data types. In addition, `DELETE` can only be used on top-level attributes, not nested attributes.
     *
     * You can have many actions in a single expression, such as the following: `SET a=:value1, b=:value2 DELETE :value3, :value4, :value5`
     *
     * For more information on update expressions, see [Modifying Items and Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val updateExpression: kotlin.String? = builder.updateExpression

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.UpdateItemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateItemRequest(")
        append("attributeUpdates=$attributeUpdates,")
        append("conditionExpression=$conditionExpression,")
        append("conditionalOperator=$conditionalOperator,")
        append("expected=$expected,")
        append("expressionAttributeNames=$expressionAttributeNames,")
        append("expressionAttributeValues=$expressionAttributeValues,")
        append("key=$key,")
        append("returnConsumedCapacity=$returnConsumedCapacity,")
        append("returnItemCollectionMetrics=$returnItemCollectionMetrics,")
        append("returnValues=$returnValues,")
        append("returnValuesOnConditionCheckFailure=$returnValuesOnConditionCheckFailure,")
        append("tableName=$tableName,")
        append("updateExpression=$updateExpression")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeUpdates?.hashCode() ?: 0
        result = 31 * result + (conditionExpression?.hashCode() ?: 0)
        result = 31 * result + (conditionalOperator?.hashCode() ?: 0)
        result = 31 * result + (expected?.hashCode() ?: 0)
        result = 31 * result + (expressionAttributeNames?.hashCode() ?: 0)
        result = 31 * result + (expressionAttributeValues?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (returnConsumedCapacity?.hashCode() ?: 0)
        result = 31 * result + (returnItemCollectionMetrics?.hashCode() ?: 0)
        result = 31 * result + (returnValues?.hashCode() ?: 0)
        result = 31 * result + (returnValuesOnConditionCheckFailure?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (updateExpression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateItemRequest

        if (attributeUpdates != other.attributeUpdates) return false
        if (conditionExpression != other.conditionExpression) return false
        if (conditionalOperator != other.conditionalOperator) return false
        if (expected != other.expected) return false
        if (expressionAttributeNames != other.expressionAttributeNames) return false
        if (expressionAttributeValues != other.expressionAttributeValues) return false
        if (key != other.key) return false
        if (returnConsumedCapacity != other.returnConsumedCapacity) return false
        if (returnItemCollectionMetrics != other.returnItemCollectionMetrics) return false
        if (returnValues != other.returnValues) return false
        if (returnValuesOnConditionCheckFailure != other.returnValuesOnConditionCheckFailure) return false
        if (tableName != other.tableName) return false
        if (updateExpression != other.updateExpression) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.UpdateItemRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This is a legacy parameter. Use `UpdateExpression` instead. For more information, see [AttributeUpdates](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var attributeUpdates: Map<String, AttributeValueUpdate>? = null
        /**
         * A condition that must be satisfied in order for a conditional update to succeed.
         *
         * An expression can contain any of the following:
         * + Functions: `attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size`These function names are case-sensitive.
         * + Comparison operators: `= | <> | < | > | <= | >= | BETWEEN | IN `
         * +  Logical operators: `AND | OR | NOT`
         *
         * For more information about condition expressions, see [Specifying Conditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var conditionExpression: kotlin.String? = null
        /**
         * This is a legacy parameter. Use `ConditionExpression` instead. For more information, see [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var conditionalOperator: aws.sdk.kotlin.services.dynamodb.model.ConditionalOperator? = null
        /**
         * This is a legacy parameter. Use `ConditionExpression` instead. For more information, see [Expected](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var expected: Map<String, ExpectedAttributeValue>? = null
        /**
         * One or more substitution tokens for attribute names in an expression. The following are some use cases for using `ExpressionAttributeNames`:
         * + To access an attribute whose name conflicts with a DynamoDB reserved word.
         * + To create a placeholder for repeating occurrences of an attribute name in an expression.
         * + To prevent special characters in an attribute name from being misinterpreted in an expression.
         *
         * Use the **#** character in an expression to dereference an attribute name. For example, consider the following attribute name:
         * + `Percentile`
         *
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*.) To work around this, you could specify the following for `ExpressionAttributeNames`:
         * + `{"#P":"Percentile"}`
         *
         * You could then use this substitution in an expression, as in this example:
         * + `#P = :val`
         *
         * Tokens that begin with the **:** character are *expression attribute values*, which are placeholders for the actual value at runtime.
         *
         * For more information about expression attribute names, see [Specifying Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var expressionAttributeNames: Map<String, String>? = null
        /**
         * One or more values that can be substituted in an expression.
         *
         * Use the **:** (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the `ProductStatus` attribute was one of the following:
         *
         * `Available | Backordered | Discontinued`
         *
         * You would first need to specify `ExpressionAttributeValues` as follows:
         *
         * `{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }`
         *
         * You could then use these values in an expression, such as this:
         *
         * `ProductStatus IN (:avail, :back, :disc)`
         *
         * For more information on expression attribute values, see [Condition Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var expressionAttributeValues: Map<String, AttributeValue>? = null
        /**
         * The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.
         *
         * For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.
         */
        public var key: Map<String, AttributeValue>? = null
        /**
         * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:
         * + `INDEXES` - The response includes the aggregate `ConsumedCapacity` for the operation, together with `ConsumedCapacity` for each table and secondary index that was accessed.Note that some operations, such as `GetItem` and `BatchGetItem`, do not access any indexes at all. In these cases, specifying `INDEXES` will only return `ConsumedCapacity` information for table(s).
         * + `TOTAL` - The response includes only the aggregate `ConsumedCapacity` for the operation.
         * + `NONE` - No `ConsumedCapacity` details are included in the response.
         */
        public var returnConsumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity? = null
        /**
         * Determines whether item collection metrics are returned. If set to `SIZE`, the response includes statistics about item collections, if any, that were modified during the operation are returned in the response. If set to `NONE` (the default), no statistics are returned.
         */
        public var returnItemCollectionMetrics: aws.sdk.kotlin.services.dynamodb.model.ReturnItemCollectionMetrics? = null
        /**
         * Use `ReturnValues` if you want to get the item attributes as they appear before or after they are successfully updated. For `UpdateItem`, the valid values are:
         * + `NONE` - If `ReturnValues` is not specified, or if its value is `NONE`, then nothing is returned. (This setting is the default for `ReturnValues`.)
         * + `ALL_OLD` - Returns all of the attributes of the item, as they appeared before the UpdateItem operation.
         * + `UPDATED_OLD` - Returns only the updated attributes, as they appeared before the UpdateItem operation.
         * + `ALL_NEW` - Returns all of the attributes of the item, as they appear after the UpdateItem operation.
         * + `UPDATED_NEW` - Returns only the updated attributes, as they appear after the UpdateItem operation.
         *
         * There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.
         *
         * The values returned are strongly consistent.
         */
        public var returnValues: aws.sdk.kotlin.services.dynamodb.model.ReturnValue? = null
        /**
         * An optional parameter that returns the item attributes for an `UpdateItem` operation that failed a condition check.
         *
         * There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.
         */
        public var returnValuesOnConditionCheckFailure: aws.sdk.kotlin.services.dynamodb.model.ReturnValuesOnConditionCheckFailure? = null
        /**
         * The name of the table containing the item to update.
         */
        public var tableName: kotlin.String? = null
        /**
         * An expression that defines one or more attributes to be updated, the action to be performed on them, and new values for them.
         *
         * The following action values are available for `UpdateExpression`.
         * + `SET` - Adds one or more attributes and values to an item. If any of these attributes already exist, they are replaced by the new values. You can also use `SET` to add or subtract from an attribute that is of type Number. For example: `SET myNum = myNum + :val``SET` supports the following functions:
         *    + `if_not_exists (path, operand)` - if the item does not contain an attribute at the specified path, then `if_not_exists` evaluates to operand; otherwise, it evaluates to path. You can use this function to avoid overwriting an attribute that may already be present in the item.
         *    + `list_append (operand, operand)` - evaluates to a list with a new element added to it. You can append the new element to the start or the end of the list by reversing the order of the operands.
         * These function names are case-sensitive.
         * + `REMOVE` - Removes one or more attributes from an item.
         * + `ADD` - Adds the specified value to the item, if the attribute does not already exist. If the attribute does exist, then the behavior of `ADD` depends on the data type of the attribute:
         *    + If the existing attribute is a number, and if `Value` is also a number, then `Value` is mathematically added to the existing attribute. If `Value` is a negative number, then it is subtracted from the existing attribute.If you use `ADD` to increment or decrement a number value for an item that doesn't exist before the update, DynamoDB uses `0` as the initial value.Similarly, if you use `ADD` for an existing item to increment or decrement an attribute value that doesn't exist before the update, DynamoDB uses `0` as the initial value. For example, suppose that the item you want to update doesn't have an attribute named `itemcount`, but you decide to `ADD` the number `3` to this attribute anyway. DynamoDB will create the `itemcount` attribute, set its initial value to `0`, and finally add `3` to it. The result will be a new `itemcount` attribute in the item, with a value of `3`.
         *    + If the existing data type is a set and if `Value` is also a set, then `Value` is added to the existing set. For example, if the attribute value is the set `[1,2]`, and the `ADD` action specified `[3]`, then the final attribute value is `[1,2,3]`. An error occurs if an `ADD` action is specified for a set attribute and the attribute type specified does not match the existing set type. Both sets must have the same primitive data type. For example, if the existing data type is a set of strings, the `Value` must also be a set of strings.
         * The `ADD` action only supports Number and set data types. In addition, `ADD` can only be used on top-level attributes, not nested attributes.
         * + `DELETE` - Deletes an element from a set.If a set of values is specified, then those values are subtracted from the old set. For example, if the attribute value was the set `[a,b,c]` and the `DELETE` action specifies `[a,c]`, then the final attribute value is `[b]`. Specifying an empty set is an error.The `DELETE` action only supports set data types. In addition, `DELETE` can only be used on top-level attributes, not nested attributes.
         *
         * You can have many actions in a single expression, such as the following: `SET a=:value1, b=:value2 DELETE :value3, :value4, :value5`
         *
         * For more information on update expressions, see [Modifying Items and Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var updateExpression: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.UpdateItemRequest) : this() {
            this.attributeUpdates = x.attributeUpdates
            this.conditionExpression = x.conditionExpression
            this.conditionalOperator = x.conditionalOperator
            this.expected = x.expected
            this.expressionAttributeNames = x.expressionAttributeNames
            this.expressionAttributeValues = x.expressionAttributeValues
            this.key = x.key
            this.returnConsumedCapacity = x.returnConsumedCapacity
            this.returnItemCollectionMetrics = x.returnItemCollectionMetrics
            this.returnValues = x.returnValues
            this.returnValuesOnConditionCheckFailure = x.returnValuesOnConditionCheckFailure
            this.tableName = x.tableName
            this.updateExpression = x.updateExpression
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.UpdateItemRequest = UpdateItemRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
