// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * The parameters for the table created as part of the import operation.
 */
public class TableCreationParameters private constructor(builder: Builder) {
    /**
     * The attributes of the table created as part of the import operation.
     */
    public val attributeDefinitions: List<AttributeDefinition> = requireNotNull(builder.attributeDefinitions) { "A non-null value must be provided for attributeDefinitions" }
    /**
     * The billing mode for provisioning the table created as part of the import operation.
     */
    public val billingMode: aws.sdk.kotlin.services.dynamodb.model.BillingMode? = builder.billingMode
    /**
     * The Global Secondary Indexes (GSI) of the table to be created as part of the import operation.
     */
    public val globalSecondaryIndexes: List<GlobalSecondaryIndex>? = builder.globalSecondaryIndexes
    /**
     * The primary key and option sort key of the table created as part of the import operation.
     */
    public val keySchema: List<KeySchemaElement> = requireNotNull(builder.keySchema) { "A non-null value must be provided for keySchema" }
    /**
     * Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the `UpdateTable` operation.
     *
     * For current minimum and maximum provisioned throughput values, see [Service, Account, and Table Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput? = builder.provisionedThroughput
    /**
     * Represents the settings used to enable server-side encryption.
     */
    public val sseSpecification: aws.sdk.kotlin.services.dynamodb.model.SseSpecification? = builder.sseSpecification
    /**
     * The name of the table created as part of the import operation.
     */
    public val tableName: kotlin.String = requireNotNull(builder.tableName) { "A non-null value must be provided for tableName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TableCreationParameters(")
        append("attributeDefinitions=$attributeDefinitions,")
        append("billingMode=$billingMode,")
        append("globalSecondaryIndexes=$globalSecondaryIndexes,")
        append("keySchema=$keySchema,")
        append("provisionedThroughput=$provisionedThroughput,")
        append("sseSpecification=$sseSpecification,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeDefinitions.hashCode()
        result = 31 * result + (billingMode?.hashCode() ?: 0)
        result = 31 * result + (globalSecondaryIndexes?.hashCode() ?: 0)
        result = 31 * result + (keySchema.hashCode())
        result = 31 * result + (provisionedThroughput?.hashCode() ?: 0)
        result = 31 * result + (sseSpecification?.hashCode() ?: 0)
        result = 31 * result + (tableName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TableCreationParameters

        if (attributeDefinitions != other.attributeDefinitions) return false
        if (billingMode != other.billingMode) return false
        if (globalSecondaryIndexes != other.globalSecondaryIndexes) return false
        if (keySchema != other.keySchema) return false
        if (provisionedThroughput != other.provisionedThroughput) return false
        if (sseSpecification != other.sseSpecification) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The attributes of the table created as part of the import operation.
         */
        public var attributeDefinitions: List<AttributeDefinition>? = null
        /**
         * The billing mode for provisioning the table created as part of the import operation.
         */
        public var billingMode: aws.sdk.kotlin.services.dynamodb.model.BillingMode? = null
        /**
         * The Global Secondary Indexes (GSI) of the table to be created as part of the import operation.
         */
        public var globalSecondaryIndexes: List<GlobalSecondaryIndex>? = null
        /**
         * The primary key and option sort key of the table created as part of the import operation.
         */
        public var keySchema: List<KeySchemaElement>? = null
        /**
         * Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the `UpdateTable` operation.
         *
         * For current minimum and maximum provisioned throughput values, see [Service, Account, and Table Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput? = null
        /**
         * Represents the settings used to enable server-side encryption.
         */
        public var sseSpecification: aws.sdk.kotlin.services.dynamodb.model.SseSpecification? = null
        /**
         * The name of the table created as part of the import operation.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters) : this() {
            this.attributeDefinitions = x.attributeDefinitions
            this.billingMode = x.billingMode
            this.globalSecondaryIndexes = x.globalSecondaryIndexes
            this.keySchema = x.keySchema
            this.provisionedThroughput = x.provisionedThroughput
            this.sseSpecification = x.sseSpecification
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters = TableCreationParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput] inside the given [block]
         */
        public fun provisionedThroughput(block: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput.Builder.() -> kotlin.Unit) {
            this.provisionedThroughput = aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.SseSpecification] inside the given [block]
         */
        public fun sseSpecification(block: aws.sdk.kotlin.services.dynamodb.model.SseSpecification.Builder.() -> kotlin.Unit) {
            this.sseSpecification = aws.sdk.kotlin.services.dynamodb.model.SseSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (attributeDefinitions == null) attributeDefinitions = emptyList()
            if (keySchema == null) keySchema = emptyList()
            if (tableName == null) tableName = ""
            return this
        }
    }
}
