// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents one of the following:
 * + A new replica to be added to an existing regional table or global table. This request invokes the `CreateTableReplica` action in the destination Region.
 * + New parameters for an existing replica. This request invokes the `UpdateTable` action in the destination Region.
 * + An existing replica to be deleted. The request invokes the `DeleteTableReplica` action in the destination Region, deleting the replica and all if its items in the destination Region.
 *
 * When you manually remove a table or global table replica, you do not automatically remove any associated scalable targets, scaling policies, or CloudWatch alarms.
 */
public class ReplicationGroupUpdate private constructor(builder: Builder) {
    /**
     * The parameters required for creating a replica for the table.
     */
    public val create: aws.sdk.kotlin.services.dynamodb.model.CreateReplicationGroupMemberAction? = builder.create
    /**
     * The parameters required for deleting a replica for the table.
     */
    public val delete: aws.sdk.kotlin.services.dynamodb.model.DeleteReplicationGroupMemberAction? = builder.delete
    /**
     * The parameters required for updating a replica for the table.
     */
    public val update: aws.sdk.kotlin.services.dynamodb.model.UpdateReplicationGroupMemberAction? = builder.update

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ReplicationGroupUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationGroupUpdate(")
        append("create=$create,")
        append("delete=$delete,")
        append("update=$update")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = create?.hashCode() ?: 0
        result = 31 * result + (delete?.hashCode() ?: 0)
        result = 31 * result + (update?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationGroupUpdate

        if (create != other.create) return false
        if (delete != other.delete) return false
        if (update != other.update) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ReplicationGroupUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The parameters required for creating a replica for the table.
         */
        public var create: aws.sdk.kotlin.services.dynamodb.model.CreateReplicationGroupMemberAction? = null
        /**
         * The parameters required for deleting a replica for the table.
         */
        public var delete: aws.sdk.kotlin.services.dynamodb.model.DeleteReplicationGroupMemberAction? = null
        /**
         * The parameters required for updating a replica for the table.
         */
        public var update: aws.sdk.kotlin.services.dynamodb.model.UpdateReplicationGroupMemberAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ReplicationGroupUpdate) : this() {
            this.create = x.create
            this.delete = x.delete
            this.update = x.update
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ReplicationGroupUpdate = ReplicationGroupUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.CreateReplicationGroupMemberAction] inside the given [block]
         */
        public fun create(block: aws.sdk.kotlin.services.dynamodb.model.CreateReplicationGroupMemberAction.Builder.() -> kotlin.Unit) {
            this.create = aws.sdk.kotlin.services.dynamodb.model.CreateReplicationGroupMemberAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.DeleteReplicationGroupMemberAction] inside the given [block]
         */
        public fun delete(block: aws.sdk.kotlin.services.dynamodb.model.DeleteReplicationGroupMemberAction.Builder.() -> kotlin.Unit) {
            this.delete = aws.sdk.kotlin.services.dynamodb.model.DeleteReplicationGroupMemberAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.UpdateReplicationGroupMemberAction] inside the given [block]
         */
        public fun update(block: aws.sdk.kotlin.services.dynamodb.model.UpdateReplicationGroupMemberAction.Builder.() -> kotlin.Unit) {
            this.update = aws.sdk.kotlin.services.dynamodb.model.UpdateReplicationGroupMemberAction.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
