// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the properties of a replica.
 */
public class ReplicaSettingsDescription private constructor(builder: Builder) {
    /**
     * The Region name of the replica.
     */
    public val regionName: kotlin.String = requireNotNull(builder.regionName) { "A non-null value must be provided for regionName" }
    /**
     * The read/write capacity mode of the replica.
     */
    public val replicaBillingModeSummary: aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary? = builder.replicaBillingModeSummary
    /**
     * Replica global secondary index settings for the global table.
     */
    public val replicaGlobalSecondaryIndexSettings: List<ReplicaGlobalSecondaryIndexSettingsDescription>? = builder.replicaGlobalSecondaryIndexSettings
    /**
     * Auto scaling settings for a global table replica's read capacity units.
     */
    public val replicaProvisionedReadCapacityAutoScalingSettings: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription? = builder.replicaProvisionedReadCapacityAutoScalingSettings
    /**
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput) in the *Amazon DynamoDB Developer Guide*.
     */
    public val replicaProvisionedReadCapacityUnits: kotlin.Long? = builder.replicaProvisionedReadCapacityUnits
    /**
     * Auto scaling settings for a global table replica's write capacity units.
     */
    public val replicaProvisionedWriteCapacityAutoScalingSettings: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription? = builder.replicaProvisionedWriteCapacityAutoScalingSettings
    /**
     * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException`. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput) in the *Amazon DynamoDB Developer Guide*.
     */
    public val replicaProvisionedWriteCapacityUnits: kotlin.Long? = builder.replicaProvisionedWriteCapacityUnits
    /**
     * The current state of the Region:
     * + `CREATING` - The Region is being created.
     * + `UPDATING` - The Region is being updated.
     * + `DELETING` - The Region is being deleted.
     * + `ACTIVE` - The Region is ready for use.
     */
    public val replicaStatus: aws.sdk.kotlin.services.dynamodb.model.ReplicaStatus? = builder.replicaStatus
    /**
     * Contains details of the table class.
     */
    public val replicaTableClassSummary: aws.sdk.kotlin.services.dynamodb.model.TableClassSummary? = builder.replicaTableClassSummary

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ReplicaSettingsDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicaSettingsDescription(")
        append("regionName=$regionName,")
        append("replicaBillingModeSummary=$replicaBillingModeSummary,")
        append("replicaGlobalSecondaryIndexSettings=$replicaGlobalSecondaryIndexSettings,")
        append("replicaProvisionedReadCapacityAutoScalingSettings=$replicaProvisionedReadCapacityAutoScalingSettings,")
        append("replicaProvisionedReadCapacityUnits=$replicaProvisionedReadCapacityUnits,")
        append("replicaProvisionedWriteCapacityAutoScalingSettings=$replicaProvisionedWriteCapacityAutoScalingSettings,")
        append("replicaProvisionedWriteCapacityUnits=$replicaProvisionedWriteCapacityUnits,")
        append("replicaStatus=$replicaStatus,")
        append("replicaTableClassSummary=$replicaTableClassSummary")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = regionName.hashCode()
        result = 31 * result + (replicaBillingModeSummary?.hashCode() ?: 0)
        result = 31 * result + (replicaGlobalSecondaryIndexSettings?.hashCode() ?: 0)
        result = 31 * result + (replicaProvisionedReadCapacityAutoScalingSettings?.hashCode() ?: 0)
        result = 31 * result + (replicaProvisionedReadCapacityUnits?.hashCode() ?: 0)
        result = 31 * result + (replicaProvisionedWriteCapacityAutoScalingSettings?.hashCode() ?: 0)
        result = 31 * result + (replicaProvisionedWriteCapacityUnits?.hashCode() ?: 0)
        result = 31 * result + (replicaStatus?.hashCode() ?: 0)
        result = 31 * result + (replicaTableClassSummary?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicaSettingsDescription

        if (regionName != other.regionName) return false
        if (replicaBillingModeSummary != other.replicaBillingModeSummary) return false
        if (replicaGlobalSecondaryIndexSettings != other.replicaGlobalSecondaryIndexSettings) return false
        if (replicaProvisionedReadCapacityAutoScalingSettings != other.replicaProvisionedReadCapacityAutoScalingSettings) return false
        if (replicaProvisionedReadCapacityUnits != other.replicaProvisionedReadCapacityUnits) return false
        if (replicaProvisionedWriteCapacityAutoScalingSettings != other.replicaProvisionedWriteCapacityAutoScalingSettings) return false
        if (replicaProvisionedWriteCapacityUnits != other.replicaProvisionedWriteCapacityUnits) return false
        if (replicaStatus != other.replicaStatus) return false
        if (replicaTableClassSummary != other.replicaTableClassSummary) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ReplicaSettingsDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Region name of the replica.
         */
        public var regionName: kotlin.String? = null
        /**
         * The read/write capacity mode of the replica.
         */
        public var replicaBillingModeSummary: aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary? = null
        /**
         * Replica global secondary index settings for the global table.
         */
        public var replicaGlobalSecondaryIndexSettings: List<ReplicaGlobalSecondaryIndexSettingsDescription>? = null
        /**
         * Auto scaling settings for a global table replica's read capacity units.
         */
        public var replicaProvisionedReadCapacityAutoScalingSettings: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription? = null
        /**
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput) in the *Amazon DynamoDB Developer Guide*.
         */
        public var replicaProvisionedReadCapacityUnits: kotlin.Long? = null
        /**
         * Auto scaling settings for a global table replica's write capacity units.
         */
        public var replicaProvisionedWriteCapacityAutoScalingSettings: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription? = null
        /**
         * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException`. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput) in the *Amazon DynamoDB Developer Guide*.
         */
        public var replicaProvisionedWriteCapacityUnits: kotlin.Long? = null
        /**
         * The current state of the Region:
         * + `CREATING` - The Region is being created.
         * + `UPDATING` - The Region is being updated.
         * + `DELETING` - The Region is being deleted.
         * + `ACTIVE` - The Region is ready for use.
         */
        public var replicaStatus: aws.sdk.kotlin.services.dynamodb.model.ReplicaStatus? = null
        /**
         * Contains details of the table class.
         */
        public var replicaTableClassSummary: aws.sdk.kotlin.services.dynamodb.model.TableClassSummary? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ReplicaSettingsDescription) : this() {
            this.regionName = x.regionName
            this.replicaBillingModeSummary = x.replicaBillingModeSummary
            this.replicaGlobalSecondaryIndexSettings = x.replicaGlobalSecondaryIndexSettings
            this.replicaProvisionedReadCapacityAutoScalingSettings = x.replicaProvisionedReadCapacityAutoScalingSettings
            this.replicaProvisionedReadCapacityUnits = x.replicaProvisionedReadCapacityUnits
            this.replicaProvisionedWriteCapacityAutoScalingSettings = x.replicaProvisionedWriteCapacityAutoScalingSettings
            this.replicaProvisionedWriteCapacityUnits = x.replicaProvisionedWriteCapacityUnits
            this.replicaStatus = x.replicaStatus
            this.replicaTableClassSummary = x.replicaTableClassSummary
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ReplicaSettingsDescription = ReplicaSettingsDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary] inside the given [block]
         */
        public fun replicaBillingModeSummary(block: aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary.Builder.() -> kotlin.Unit) {
            this.replicaBillingModeSummary = aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription] inside the given [block]
         */
        public fun replicaProvisionedReadCapacityAutoScalingSettings(block: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription.Builder.() -> kotlin.Unit) {
            this.replicaProvisionedReadCapacityAutoScalingSettings = aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription] inside the given [block]
         */
        public fun replicaProvisionedWriteCapacityAutoScalingSettings(block: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription.Builder.() -> kotlin.Unit) {
            this.replicaProvisionedWriteCapacityAutoScalingSettings = aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.TableClassSummary] inside the given [block]
         */
        public fun replicaTableClassSummary(block: aws.sdk.kotlin.services.dynamodb.model.TableClassSummary.Builder.() -> kotlin.Unit) {
            this.replicaTableClassSummary = aws.sdk.kotlin.services.dynamodb.model.TableClassSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (regionName == null) regionName = ""
            return this
        }
    }
}
