// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the settings of a global secondary index for a global table that will be modified.
 */
public class ReplicaGlobalSecondaryIndexSettingsUpdate private constructor(builder: Builder) {
    /**
     * The name of the global secondary index. The name must be unique among all other indexes on this table.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * Auto scaling settings for managing a global secondary index replica's read capacity units.
     */
    public val provisionedReadCapacityAutoScalingSettingsUpdate: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate? = builder.provisionedReadCapacityAutoScalingSettingsUpdate
    /**
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`.
     */
    public val provisionedReadCapacityUnits: kotlin.Long? = builder.provisionedReadCapacityUnits

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicaGlobalSecondaryIndexSettingsUpdate(")
        append("indexName=$indexName,")
        append("provisionedReadCapacityAutoScalingSettingsUpdate=$provisionedReadCapacityAutoScalingSettingsUpdate,")
        append("provisionedReadCapacityUnits=$provisionedReadCapacityUnits")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = indexName.hashCode()
        result = 31 * result + (provisionedReadCapacityAutoScalingSettingsUpdate?.hashCode() ?: 0)
        result = 31 * result + (provisionedReadCapacityUnits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicaGlobalSecondaryIndexSettingsUpdate

        if (indexName != other.indexName) return false
        if (provisionedReadCapacityAutoScalingSettingsUpdate != other.provisionedReadCapacityAutoScalingSettingsUpdate) return false
        if (provisionedReadCapacityUnits != other.provisionedReadCapacityUnits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the global secondary index. The name must be unique among all other indexes on this table.
         */
        public var indexName: kotlin.String? = null
        /**
         * Auto scaling settings for managing a global secondary index replica's read capacity units.
         */
        public var provisionedReadCapacityAutoScalingSettingsUpdate: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate? = null
        /**
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`.
         */
        public var provisionedReadCapacityUnits: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate) : this() {
            this.indexName = x.indexName
            this.provisionedReadCapacityAutoScalingSettingsUpdate = x.provisionedReadCapacityAutoScalingSettingsUpdate
            this.provisionedReadCapacityUnits = x.provisionedReadCapacityUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate = ReplicaGlobalSecondaryIndexSettingsUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate] inside the given [block]
         */
        public fun provisionedReadCapacityAutoScalingSettingsUpdate(block: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate.Builder.() -> kotlin.Unit) {
            this.provisionedReadCapacityAutoScalingSettingsUpdate = aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (indexName == null) indexName = ""
            return this
        }
    }
}
