// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the properties of a global secondary index.
 */
public class ReplicaGlobalSecondaryIndexSettingsDescription private constructor(builder: Builder) {
    /**
     * The name of the global secondary index. The name must be unique among all other indexes on this table.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * The current status of the global secondary index:
     * + `CREATING` - The global secondary index is being created.
     * + `UPDATING` - The global secondary index is being updated.
     * + `DELETING` - The global secondary index is being deleted.
     * + `ACTIVE` - The global secondary index is ready for use.
     */
    public val indexStatus: aws.sdk.kotlin.services.dynamodb.model.IndexStatus? = builder.indexStatus
    /**
     * Auto scaling settings for a global secondary index replica's read capacity units.
     */
    public val provisionedReadCapacityAutoScalingSettings: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription? = builder.provisionedReadCapacityAutoScalingSettings
    /**
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`.
     */
    public val provisionedReadCapacityUnits: kotlin.Long? = builder.provisionedReadCapacityUnits
    /**
     * Auto scaling settings for a global secondary index replica's write capacity units.
     */
    public val provisionedWriteCapacityAutoScalingSettings: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription? = builder.provisionedWriteCapacityAutoScalingSettings
    /**
     * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException`.
     */
    public val provisionedWriteCapacityUnits: kotlin.Long? = builder.provisionedWriteCapacityUnits

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicaGlobalSecondaryIndexSettingsDescription(")
        append("indexName=$indexName,")
        append("indexStatus=$indexStatus,")
        append("provisionedReadCapacityAutoScalingSettings=$provisionedReadCapacityAutoScalingSettings,")
        append("provisionedReadCapacityUnits=$provisionedReadCapacityUnits,")
        append("provisionedWriteCapacityAutoScalingSettings=$provisionedWriteCapacityAutoScalingSettings,")
        append("provisionedWriteCapacityUnits=$provisionedWriteCapacityUnits")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = indexName.hashCode()
        result = 31 * result + (indexStatus?.hashCode() ?: 0)
        result = 31 * result + (provisionedReadCapacityAutoScalingSettings?.hashCode() ?: 0)
        result = 31 * result + (provisionedReadCapacityUnits?.hashCode() ?: 0)
        result = 31 * result + (provisionedWriteCapacityAutoScalingSettings?.hashCode() ?: 0)
        result = 31 * result + (provisionedWriteCapacityUnits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicaGlobalSecondaryIndexSettingsDescription

        if (indexName != other.indexName) return false
        if (indexStatus != other.indexStatus) return false
        if (provisionedReadCapacityAutoScalingSettings != other.provisionedReadCapacityAutoScalingSettings) return false
        if (provisionedReadCapacityUnits != other.provisionedReadCapacityUnits) return false
        if (provisionedWriteCapacityAutoScalingSettings != other.provisionedWriteCapacityAutoScalingSettings) return false
        if (provisionedWriteCapacityUnits != other.provisionedWriteCapacityUnits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the global secondary index. The name must be unique among all other indexes on this table.
         */
        public var indexName: kotlin.String? = null
        /**
         * The current status of the global secondary index:
         * + `CREATING` - The global secondary index is being created.
         * + `UPDATING` - The global secondary index is being updated.
         * + `DELETING` - The global secondary index is being deleted.
         * + `ACTIVE` - The global secondary index is ready for use.
         */
        public var indexStatus: aws.sdk.kotlin.services.dynamodb.model.IndexStatus? = null
        /**
         * Auto scaling settings for a global secondary index replica's read capacity units.
         */
        public var provisionedReadCapacityAutoScalingSettings: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription? = null
        /**
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`.
         */
        public var provisionedReadCapacityUnits: kotlin.Long? = null
        /**
         * Auto scaling settings for a global secondary index replica's write capacity units.
         */
        public var provisionedWriteCapacityAutoScalingSettings: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription? = null
        /**
         * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException`.
         */
        public var provisionedWriteCapacityUnits: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription) : this() {
            this.indexName = x.indexName
            this.indexStatus = x.indexStatus
            this.provisionedReadCapacityAutoScalingSettings = x.provisionedReadCapacityAutoScalingSettings
            this.provisionedReadCapacityUnits = x.provisionedReadCapacityUnits
            this.provisionedWriteCapacityAutoScalingSettings = x.provisionedWriteCapacityAutoScalingSettings
            this.provisionedWriteCapacityUnits = x.provisionedWriteCapacityUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription = ReplicaGlobalSecondaryIndexSettingsDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription] inside the given [block]
         */
        public fun provisionedReadCapacityAutoScalingSettings(block: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription.Builder.() -> kotlin.Unit) {
            this.provisionedReadCapacityAutoScalingSettings = aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription] inside the given [block]
         */
        public fun provisionedWriteCapacityAutoScalingSettings(block: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription.Builder.() -> kotlin.Unit) {
            this.provisionedWriteCapacityAutoScalingSettings = aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsDescription.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (indexName == null) indexName = ""
            return this
        }
    }
}
