// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the `UpdateTable` operation.
 *
 * For current minimum and maximum provisioned throughput values, see [Service, Account, and Table Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the *Amazon DynamoDB Developer Guide*.
 */
public class ProvisionedThroughput private constructor(builder: Builder) {
    /**
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html) in the *Amazon DynamoDB Developer Guide*.
     *
     * If read/write capacity mode is `PAY_PER_REQUEST` the value is set to 0.
     */
    public val readCapacityUnits: kotlin.Long = requireNotNull(builder.readCapacityUnits) { "A non-null value must be provided for readCapacityUnits" }
    /**
     * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException`. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html) in the *Amazon DynamoDB Developer Guide*.
     *
     * If read/write capacity mode is `PAY_PER_REQUEST` the value is set to 0.
     */
    public val writeCapacityUnits: kotlin.Long = requireNotNull(builder.writeCapacityUnits) { "A non-null value must be provided for writeCapacityUnits" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisionedThroughput(")
        append("readCapacityUnits=$readCapacityUnits,")
        append("writeCapacityUnits=$writeCapacityUnits")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = readCapacityUnits.hashCode()
        result = 31 * result + (writeCapacityUnits.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisionedThroughput

        if (readCapacityUnits != other.readCapacityUnits) return false
        if (writeCapacityUnits != other.writeCapacityUnits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html) in the *Amazon DynamoDB Developer Guide*.
         *
         * If read/write capacity mode is `PAY_PER_REQUEST` the value is set to 0.
         */
        public var readCapacityUnits: kotlin.Long? = null
        /**
         * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException`. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html) in the *Amazon DynamoDB Developer Guide*.
         *
         * If read/write capacity mode is `PAY_PER_REQUEST` the value is set to 0.
         */
        public var writeCapacityUnits: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput) : this() {
            this.readCapacityUnits = x.readCapacityUnits
            this.writeCapacityUnits = x.writeCapacityUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput = ProvisionedThroughput(this)

        internal fun correctErrors(): Builder {
            if (readCapacityUnits == null) readCapacityUnits = 0L
            if (writeCapacityUnits == null) writeCapacityUnits = 0L
            return this
        }
    }
}
