// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents a set of primary keys and, for each key, the attributes to retrieve from the table.
 *
 * For each primary key, you must provide *all* of the key attributes. For example, with a simple primary key, you only need to provide the partition key. For a composite primary key, you must provide *both* the partition key and the sort key.
 */
public class KeysAndAttributes private constructor(builder: Builder) {
    /**
     * This is a legacy parameter. Use `ProjectionExpression` instead. For more information, see [Legacy Conditional Parameters](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val attributesToGet: List<String>? = builder.attributesToGet
    /**
     * The consistency of a read operation. If set to `true`, then a strongly consistent read is used; otherwise, an eventually consistent read is used.
     */
    public val consistentRead: kotlin.Boolean? = builder.consistentRead
    /**
     * One or more substitution tokens for attribute names in an expression. The following are some use cases for using `ExpressionAttributeNames`:
     * + To access an attribute whose name conflicts with a DynamoDB reserved word.
     * + To create a placeholder for repeating occurrences of an attribute name in an expression.
     * + To prevent special characters in an attribute name from being misinterpreted in an expression.
     *
     * Use the **#** character in an expression to dereference an attribute name. For example, consider the following attribute name:
     * + `Percentile`
     *
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*). To work around this, you could specify the following for `ExpressionAttributeNames`:
     * + `{"#P":"Percentile"}`
     *
     * You could then use this substitution in an expression, as in this example:
     * + `#P = :val`
     *
     * Tokens that begin with the **:** character are *expression attribute values*, which are placeholders for the actual value at runtime.
     *
     * For more information on expression attribute names, see [Accessing Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val expressionAttributeNames: Map<String, String>? = builder.expressionAttributeNames
    /**
     * The primary key attribute values that define the items and the attributes associated with the items.
     */
    public val keys: List<Map<String, AttributeValue>> = requireNotNull(builder.keys) { "A non-null value must be provided for keys" }
    /**
     * A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the `ProjectionExpression` must be separated by commas.
     *
     * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.
     *
     * For more information, see [Accessing Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val projectionExpression: kotlin.String? = builder.projectionExpression

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.KeysAndAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KeysAndAttributes(")
        append("attributesToGet=$attributesToGet,")
        append("consistentRead=$consistentRead,")
        append("expressionAttributeNames=$expressionAttributeNames,")
        append("keys=$keys,")
        append("projectionExpression=$projectionExpression")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributesToGet?.hashCode() ?: 0
        result = 31 * result + (consistentRead?.hashCode() ?: 0)
        result = 31 * result + (expressionAttributeNames?.hashCode() ?: 0)
        result = 31 * result + (keys.hashCode())
        result = 31 * result + (projectionExpression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KeysAndAttributes

        if (attributesToGet != other.attributesToGet) return false
        if (consistentRead != other.consistentRead) return false
        if (expressionAttributeNames != other.expressionAttributeNames) return false
        if (keys != other.keys) return false
        if (projectionExpression != other.projectionExpression) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.KeysAndAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This is a legacy parameter. Use `ProjectionExpression` instead. For more information, see [Legacy Conditional Parameters](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var attributesToGet: List<String>? = null
        /**
         * The consistency of a read operation. If set to `true`, then a strongly consistent read is used; otherwise, an eventually consistent read is used.
         */
        public var consistentRead: kotlin.Boolean? = null
        /**
         * One or more substitution tokens for attribute names in an expression. The following are some use cases for using `ExpressionAttributeNames`:
         * + To access an attribute whose name conflicts with a DynamoDB reserved word.
         * + To create a placeholder for repeating occurrences of an attribute name in an expression.
         * + To prevent special characters in an attribute name from being misinterpreted in an expression.
         *
         * Use the **#** character in an expression to dereference an attribute name. For example, consider the following attribute name:
         * + `Percentile`
         *
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*). To work around this, you could specify the following for `ExpressionAttributeNames`:
         * + `{"#P":"Percentile"}`
         *
         * You could then use this substitution in an expression, as in this example:
         * + `#P = :val`
         *
         * Tokens that begin with the **:** character are *expression attribute values*, which are placeholders for the actual value at runtime.
         *
         * For more information on expression attribute names, see [Accessing Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var expressionAttributeNames: Map<String, String>? = null
        /**
         * The primary key attribute values that define the items and the attributes associated with the items.
         */
        public var keys: List<Map<String, AttributeValue>>? = null
        /**
         * A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the `ProjectionExpression` must be separated by commas.
         *
         * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.
         *
         * For more information, see [Accessing Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var projectionExpression: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.KeysAndAttributes) : this() {
            this.attributesToGet = x.attributesToGet
            this.consistentRead = x.consistentRead
            this.expressionAttributeNames = x.expressionAttributeNames
            this.keys = x.keys
            this.projectionExpression = x.projectionExpression
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.KeysAndAttributes = KeysAndAttributes(this)

        internal fun correctErrors(): Builder {
            if (keys == null) keys = emptyList()
            return this
        }
    }
}
