// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents *a single element* of a key schema. A key schema specifies the attributes that make up the primary key of a table, or the key attributes of an index.
 *
 * A `KeySchemaElement` represents exactly one attribute of the primary key. For example, a simple primary key would be represented by one `KeySchemaElement` (for the partition key). A composite primary key would require one `KeySchemaElement` for the partition key, and another `KeySchemaElement` for the sort key.
 *
 * A `KeySchemaElement` must be a scalar, top-level attribute (not a nested attribute). The data type must be one of String, Number, or Binary. The attribute cannot be nested within a List or a Map.
 */
public class KeySchemaElement private constructor(builder: Builder) {
    /**
     * The name of a key attribute.
     */
    public val attributeName: kotlin.String = requireNotNull(builder.attributeName) { "A non-null value must be provided for attributeName" }
    /**
     * The role that this key attribute will assume:
     * + `HASH` - partition key
     * + `RANGE` - sort key
     *
     * The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
     *
     * The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
     */
    public val keyType: aws.sdk.kotlin.services.dynamodb.model.KeyType = requireNotNull(builder.keyType) { "A non-null value must be provided for keyType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.KeySchemaElement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KeySchemaElement(")
        append("attributeName=$attributeName,")
        append("keyType=$keyType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName.hashCode()
        result = 31 * result + (keyType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KeySchemaElement

        if (attributeName != other.attributeName) return false
        if (keyType != other.keyType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.KeySchemaElement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of a key attribute.
         */
        public var attributeName: kotlin.String? = null
        /**
         * The role that this key attribute will assume:
         * + `HASH` - partition key
         * + `RANGE` - sort key
         *
         * The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
         *
         * The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
         */
        public var keyType: aws.sdk.kotlin.services.dynamodb.model.KeyType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.KeySchemaElement) : this() {
            this.attributeName = x.attributeName
            this.keyType = x.keyType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.KeySchemaElement = KeySchemaElement(this)

        internal fun correctErrors(): Builder {
            if (attributeName == null) attributeName = ""
            if (keyType == null) keyType = KeyType.SdkUnknown("no value provided")
            return this
        }
    }
}
