// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Optional object containing the parameters specific to an incremental export.
 */
public class IncrementalExportSpecification private constructor(builder: Builder) {
    /**
     * Time in the past which provides the inclusive start range for the export table's data, counted in seconds from the start of the Unix epoch. The incremental export will reflect the table's state including and after this point in time.
     */
    public val exportFromTime: aws.smithy.kotlin.runtime.time.Instant? = builder.exportFromTime
    /**
     * Time in the past which provides the exclusive end range for the export table's data, counted in seconds from the start of the Unix epoch. The incremental export will reflect the table's state just prior to this point in time. If this is not provided, the latest time with data available will be used.
     */
    public val exportToTime: aws.smithy.kotlin.runtime.time.Instant? = builder.exportToTime
    /**
     * The view type that was chosen for the export. Valid values are `NEW_AND_OLD_IMAGES` and `NEW_IMAGES`. The default value is `NEW_AND_OLD_IMAGES`.
     */
    public val exportViewType: aws.sdk.kotlin.services.dynamodb.model.ExportViewType? = builder.exportViewType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.IncrementalExportSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IncrementalExportSpecification(")
        append("exportFromTime=$exportFromTime,")
        append("exportToTime=$exportToTime,")
        append("exportViewType=$exportViewType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = exportFromTime?.hashCode() ?: 0
        result = 31 * result + (exportToTime?.hashCode() ?: 0)
        result = 31 * result + (exportViewType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IncrementalExportSpecification

        if (exportFromTime != other.exportFromTime) return false
        if (exportToTime != other.exportToTime) return false
        if (exportViewType != other.exportViewType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.IncrementalExportSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Time in the past which provides the inclusive start range for the export table's data, counted in seconds from the start of the Unix epoch. The incremental export will reflect the table's state including and after this point in time.
         */
        public var exportFromTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Time in the past which provides the exclusive end range for the export table's data, counted in seconds from the start of the Unix epoch. The incremental export will reflect the table's state just prior to this point in time. If this is not provided, the latest time with data available will be used.
         */
        public var exportToTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The view type that was chosen for the export. Valid values are `NEW_AND_OLD_IMAGES` and `NEW_IMAGES`. The default value is `NEW_AND_OLD_IMAGES`.
         */
        public var exportViewType: aws.sdk.kotlin.services.dynamodb.model.ExportViewType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.IncrementalExportSpecification) : this() {
            this.exportFromTime = x.exportFromTime
            this.exportToTime = x.exportToTime
            this.exportViewType = x.exportViewType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.IncrementalExportSpecification = IncrementalExportSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
