// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



public class ImportTableRequest private constructor(builder: Builder) {
    /**
     * Providing a `ClientToken` makes the call to `ImportTableInput` idempotent, meaning that multiple identical calls have the same effect as one single call.
     *
     * A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any request with the same client token is treated as a new request. Do not resubmit the same request with the same client token for more than 8 hours, or the result might not be idempotent.
     *
     * If you submit a request with the same client token but a change in other parameters within the 8-hour idempotency window, DynamoDB returns an `IdempotentParameterMismatch` exception.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Type of compression to be used on the input coming from the imported table.
     */
    public val inputCompressionType: aws.sdk.kotlin.services.dynamodb.model.InputCompressionType? = builder.inputCompressionType
    /**
     * The format of the source data. Valid values for `ImportFormat` are `CSV`, `DYNAMODB_JSON` or `ION`.
     */
    public val inputFormat: aws.sdk.kotlin.services.dynamodb.model.InputFormat? = builder.inputFormat
    /**
     * Additional properties that specify how the input is formatted,
     */
    public val inputFormatOptions: aws.sdk.kotlin.services.dynamodb.model.InputFormatOptions? = builder.inputFormatOptions
    /**
     * The S3 bucket that provides the source for the import.
     */
    public val s3BucketSource: aws.sdk.kotlin.services.dynamodb.model.S3BucketSource? = builder.s3BucketSource
    /**
     * Parameters for the table to import the data into.
     */
    public val tableCreationParameters: aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters? = builder.tableCreationParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ImportTableRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportTableRequest(")
        append("clientToken=$clientToken,")
        append("inputCompressionType=$inputCompressionType,")
        append("inputFormat=$inputFormat,")
        append("inputFormatOptions=$inputFormatOptions,")
        append("s3BucketSource=$s3BucketSource,")
        append("tableCreationParameters=$tableCreationParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (inputCompressionType?.hashCode() ?: 0)
        result = 31 * result + (inputFormat?.hashCode() ?: 0)
        result = 31 * result + (inputFormatOptions?.hashCode() ?: 0)
        result = 31 * result + (s3BucketSource?.hashCode() ?: 0)
        result = 31 * result + (tableCreationParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportTableRequest

        if (clientToken != other.clientToken) return false
        if (inputCompressionType != other.inputCompressionType) return false
        if (inputFormat != other.inputFormat) return false
        if (inputFormatOptions != other.inputFormatOptions) return false
        if (s3BucketSource != other.s3BucketSource) return false
        if (tableCreationParameters != other.tableCreationParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ImportTableRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Providing a `ClientToken` makes the call to `ImportTableInput` idempotent, meaning that multiple identical calls have the same effect as one single call.
         *
         * A client token is valid for 8 hours after the first request that uses it is completed. After 8 hours, any request with the same client token is treated as a new request. Do not resubmit the same request with the same client token for more than 8 hours, or the result might not be idempotent.
         *
         * If you submit a request with the same client token but a change in other parameters within the 8-hour idempotency window, DynamoDB returns an `IdempotentParameterMismatch` exception.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Type of compression to be used on the input coming from the imported table.
         */
        public var inputCompressionType: aws.sdk.kotlin.services.dynamodb.model.InputCompressionType? = null
        /**
         * The format of the source data. Valid values for `ImportFormat` are `CSV`, `DYNAMODB_JSON` or `ION`.
         */
        public var inputFormat: aws.sdk.kotlin.services.dynamodb.model.InputFormat? = null
        /**
         * Additional properties that specify how the input is formatted,
         */
        public var inputFormatOptions: aws.sdk.kotlin.services.dynamodb.model.InputFormatOptions? = null
        /**
         * The S3 bucket that provides the source for the import.
         */
        public var s3BucketSource: aws.sdk.kotlin.services.dynamodb.model.S3BucketSource? = null
        /**
         * Parameters for the table to import the data into.
         */
        public var tableCreationParameters: aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ImportTableRequest) : this() {
            this.clientToken = x.clientToken
            this.inputCompressionType = x.inputCompressionType
            this.inputFormat = x.inputFormat
            this.inputFormatOptions = x.inputFormatOptions
            this.s3BucketSource = x.s3BucketSource
            this.tableCreationParameters = x.tableCreationParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ImportTableRequest = ImportTableRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.InputFormatOptions] inside the given [block]
         */
        public fun inputFormatOptions(block: aws.sdk.kotlin.services.dynamodb.model.InputFormatOptions.Builder.() -> kotlin.Unit) {
            this.inputFormatOptions = aws.sdk.kotlin.services.dynamodb.model.InputFormatOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.S3BucketSource] inside the given [block]
         */
        public fun s3BucketSource(block: aws.sdk.kotlin.services.dynamodb.model.S3BucketSource.Builder.() -> kotlin.Unit) {
            this.s3BucketSource = aws.sdk.kotlin.services.dynamodb.model.S3BucketSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters] inside the given [block]
         */
        public fun tableCreationParameters(block: aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters.Builder.() -> kotlin.Unit) {
            this.tableCreationParameters = aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
