// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents one of the following:
 * + A new global secondary index to be added to an existing table.
 * + New provisioned throughput parameters for an existing global secondary index.
 * + An existing global secondary index to be removed from an existing table.
 */
public class GlobalSecondaryIndexUpdate private constructor(builder: Builder) {
    /**
     * The parameters required for creating a global secondary index on an existing table:
     * + `IndexName `
     * + `KeySchema `
     * + `AttributeDefinitions `
     * + `Projection `
     * + `ProvisionedThroughput `
     */
    public val create: aws.sdk.kotlin.services.dynamodb.model.CreateGlobalSecondaryIndexAction? = builder.create
    /**
     * The name of an existing global secondary index to be removed.
     */
    public val delete: aws.sdk.kotlin.services.dynamodb.model.DeleteGlobalSecondaryIndexAction? = builder.delete
    /**
     * The name of an existing global secondary index, along with new provisioned throughput settings to be applied to that index.
     */
    public val update: aws.sdk.kotlin.services.dynamodb.model.UpdateGlobalSecondaryIndexAction? = builder.update

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.GlobalSecondaryIndexUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalSecondaryIndexUpdate(")
        append("create=$create,")
        append("delete=$delete,")
        append("update=$update")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = create?.hashCode() ?: 0
        result = 31 * result + (delete?.hashCode() ?: 0)
        result = 31 * result + (update?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlobalSecondaryIndexUpdate

        if (create != other.create) return false
        if (delete != other.delete) return false
        if (update != other.update) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.GlobalSecondaryIndexUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The parameters required for creating a global secondary index on an existing table:
         * + `IndexName `
         * + `KeySchema `
         * + `AttributeDefinitions `
         * + `Projection `
         * + `ProvisionedThroughput `
         */
        public var create: aws.sdk.kotlin.services.dynamodb.model.CreateGlobalSecondaryIndexAction? = null
        /**
         * The name of an existing global secondary index to be removed.
         */
        public var delete: aws.sdk.kotlin.services.dynamodb.model.DeleteGlobalSecondaryIndexAction? = null
        /**
         * The name of an existing global secondary index, along with new provisioned throughput settings to be applied to that index.
         */
        public var update: aws.sdk.kotlin.services.dynamodb.model.UpdateGlobalSecondaryIndexAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.GlobalSecondaryIndexUpdate) : this() {
            this.create = x.create
            this.delete = x.delete
            this.update = x.update
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.GlobalSecondaryIndexUpdate = GlobalSecondaryIndexUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.CreateGlobalSecondaryIndexAction] inside the given [block]
         */
        public fun create(block: aws.sdk.kotlin.services.dynamodb.model.CreateGlobalSecondaryIndexAction.Builder.() -> kotlin.Unit) {
            this.create = aws.sdk.kotlin.services.dynamodb.model.CreateGlobalSecondaryIndexAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.DeleteGlobalSecondaryIndexAction] inside the given [block]
         */
        public fun delete(block: aws.sdk.kotlin.services.dynamodb.model.DeleteGlobalSecondaryIndexAction.Builder.() -> kotlin.Unit) {
            this.delete = aws.sdk.kotlin.services.dynamodb.model.DeleteGlobalSecondaryIndexAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.UpdateGlobalSecondaryIndexAction] inside the given [block]
         */
        public fun update(block: aws.sdk.kotlin.services.dynamodb.model.UpdateGlobalSecondaryIndexAction.Builder.() -> kotlin.Unit) {
            this.update = aws.sdk.kotlin.services.dynamodb.model.UpdateGlobalSecondaryIndexAction.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
