// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the input of a `GetItem` operation.
 */
public class GetItemRequest private constructor(builder: Builder) {
    /**
     * This is a legacy parameter. Use `ProjectionExpression` instead. For more information, see [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val attributesToGet: List<String>? = builder.attributesToGet
    /**
     * Determines the read consistency model: If set to `true`, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.
     */
    public val consistentRead: kotlin.Boolean? = builder.consistentRead
    /**
     * One or more substitution tokens for attribute names in an expression. The following are some use cases for using `ExpressionAttributeNames`:
     * + To access an attribute whose name conflicts with a DynamoDB reserved word.
     * + To create a placeholder for repeating occurrences of an attribute name in an expression.
     * + To prevent special characters in an attribute name from being misinterpreted in an expression.
     *
     * Use the **#** character in an expression to dereference an attribute name. For example, consider the following attribute name:
     * + `Percentile`
     *
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*). To work around this, you could specify the following for `ExpressionAttributeNames`:
     * + `{"#P":"Percentile"}`
     *
     * You could then use this substitution in an expression, as in this example:
     * + `#P = :val`
     *
     * Tokens that begin with the **:** character are *expression attribute values*, which are placeholders for the actual value at runtime.
     *
     * For more information on expression attribute names, see [Specifying Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val expressionAttributeNames: Map<String, String>? = builder.expressionAttributeNames
    /**
     * A map of attribute names to `AttributeValue` objects, representing the primary key of the item to retrieve.
     *
     * For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.
     */
    public val key: Map<String, AttributeValue>? = builder.key
    /**
     * A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.
     *
     * If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.
     *
     * For more information, see [Specifying Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val projectionExpression: kotlin.String? = builder.projectionExpression
    /**
     * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:
     * + `INDEXES` - The response includes the aggregate `ConsumedCapacity` for the operation, together with `ConsumedCapacity` for each table and secondary index that was accessed.Note that some operations, such as `GetItem` and `BatchGetItem`, do not access any indexes at all. In these cases, specifying `INDEXES` will only return `ConsumedCapacity` information for table(s).
     * + `TOTAL` - The response includes only the aggregate `ConsumedCapacity` for the operation.
     * + `NONE` - No `ConsumedCapacity` details are included in the response.
     */
    public val returnConsumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity? = builder.returnConsumedCapacity
    /**
     * The name of the table containing the requested item.
     */
    public val tableName: kotlin.String? = builder.tableName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.GetItemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetItemRequest(")
        append("attributesToGet=$attributesToGet,")
        append("consistentRead=$consistentRead,")
        append("expressionAttributeNames=$expressionAttributeNames,")
        append("key=$key,")
        append("projectionExpression=$projectionExpression,")
        append("returnConsumedCapacity=$returnConsumedCapacity,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributesToGet?.hashCode() ?: 0
        result = 31 * result + (consistentRead?.hashCode() ?: 0)
        result = 31 * result + (expressionAttributeNames?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (projectionExpression?.hashCode() ?: 0)
        result = 31 * result + (returnConsumedCapacity?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetItemRequest

        if (attributesToGet != other.attributesToGet) return false
        if (consistentRead != other.consistentRead) return false
        if (expressionAttributeNames != other.expressionAttributeNames) return false
        if (key != other.key) return false
        if (projectionExpression != other.projectionExpression) return false
        if (returnConsumedCapacity != other.returnConsumedCapacity) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.GetItemRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This is a legacy parameter. Use `ProjectionExpression` instead. For more information, see [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var attributesToGet: List<String>? = null
        /**
         * Determines the read consistency model: If set to `true`, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.
         */
        public var consistentRead: kotlin.Boolean? = null
        /**
         * One or more substitution tokens for attribute names in an expression. The following are some use cases for using `ExpressionAttributeNames`:
         * + To access an attribute whose name conflicts with a DynamoDB reserved word.
         * + To create a placeholder for repeating occurrences of an attribute name in an expression.
         * + To prevent special characters in an attribute name from being misinterpreted in an expression.
         *
         * Use the **#** character in an expression to dereference an attribute name. For example, consider the following attribute name:
         * + `Percentile`
         *
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*). To work around this, you could specify the following for `ExpressionAttributeNames`:
         * + `{"#P":"Percentile"}`
         *
         * You could then use this substitution in an expression, as in this example:
         * + `#P = :val`
         *
         * Tokens that begin with the **:** character are *expression attribute values*, which are placeholders for the actual value at runtime.
         *
         * For more information on expression attribute names, see [Specifying Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var expressionAttributeNames: Map<String, String>? = null
        /**
         * A map of attribute names to `AttributeValue` objects, representing the primary key of the item to retrieve.
         *
         * For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only need to provide a value for the partition key. For a composite primary key, you must provide values for both the partition key and the sort key.
         */
        public var key: Map<String, AttributeValue>? = null
        /**
         * A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.
         *
         * If no attribute names are specified, then all attributes are returned. If any of the requested attributes are not found, they do not appear in the result.
         *
         * For more information, see [Specifying Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var projectionExpression: kotlin.String? = null
        /**
         * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:
         * + `INDEXES` - The response includes the aggregate `ConsumedCapacity` for the operation, together with `ConsumedCapacity` for each table and secondary index that was accessed.Note that some operations, such as `GetItem` and `BatchGetItem`, do not access any indexes at all. In these cases, specifying `INDEXES` will only return `ConsumedCapacity` information for table(s).
         * + `TOTAL` - The response includes only the aggregate `ConsumedCapacity` for the operation.
         * + `NONE` - No `ConsumedCapacity` details are included in the response.
         */
        public var returnConsumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity? = null
        /**
         * The name of the table containing the requested item.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.GetItemRequest) : this() {
            this.attributesToGet = x.attributesToGet
            this.consistentRead = x.consistentRead
            this.expressionAttributeNames = x.expressionAttributeNames
            this.key = x.key
            this.projectionExpression = x.projectionExpression
            this.returnConsumedCapacity = x.returnConsumedCapacity
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.GetItemRequest = GetItemRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
