// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the properties of the exported table.
 */
public class ExportDescription private constructor(builder: Builder) {
    /**
     * The billable size of the table export.
     */
    public val billedSizeBytes: kotlin.Long? = builder.billedSizeBytes
    /**
     * The client token that was provided for the export task. A client token makes calls to `ExportTableToPointInTimeInput` idempotent, meaning that multiple identical calls have the same effect as one single call.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The time at which the export task completed.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The Amazon Resource Name (ARN) of the table export.
     */
    public val exportArn: kotlin.String? = builder.exportArn
    /**
     * The format of the exported data. Valid values for `ExportFormat` are `DYNAMODB_JSON` or `ION`.
     */
    public val exportFormat: aws.sdk.kotlin.services.dynamodb.model.ExportFormat? = builder.exportFormat
    /**
     * The name of the manifest file for the export task.
     */
    public val exportManifest: kotlin.String? = builder.exportManifest
    /**
     * Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
     */
    public val exportStatus: aws.sdk.kotlin.services.dynamodb.model.ExportStatus? = builder.exportStatus
    /**
     * Point in time from which table data was exported.
     */
    public val exportTime: aws.smithy.kotlin.runtime.time.Instant? = builder.exportTime
    /**
     * The type of export that was performed. Valid values are `FULL_EXPORT` or `INCREMENTAL_EXPORT`.
     */
    public val exportType: aws.sdk.kotlin.services.dynamodb.model.ExportType? = builder.exportType
    /**
     * Status code for the result of the failed export.
     */
    public val failureCode: kotlin.String? = builder.failureCode
    /**
     * Export failure reason description.
     */
    public val failureMessage: kotlin.String? = builder.failureMessage
    /**
     * Optional object containing the parameters specific to an incremental export.
     */
    public val incrementalExportSpecification: aws.sdk.kotlin.services.dynamodb.model.IncrementalExportSpecification? = builder.incrementalExportSpecification
    /**
     * The number of items exported.
     */
    public val itemCount: kotlin.Long? = builder.itemCount
    /**
     * The name of the Amazon S3 bucket containing the export.
     */
    public val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * The ID of the Amazon Web Services account that owns the bucket containing the export.
     */
    public val s3BucketOwner: kotlin.String? = builder.s3BucketOwner
    /**
     * The Amazon S3 bucket prefix used as the file name and path of the exported snapshot.
     */
    public val s3Prefix: kotlin.String? = builder.s3Prefix
    /**
     * Type of encryption used on the bucket where export data is stored. Valid values for `S3SseAlgorithm` are:
     * + `AES256` - server-side encryption with Amazon S3 managed keys
     * + `KMS` - server-side encryption with KMS managed keys
     */
    public val s3SseAlgorithm: aws.sdk.kotlin.services.dynamodb.model.S3SseAlgorithm? = builder.s3SseAlgorithm
    /**
     * The ID of the KMS managed key used to encrypt the S3 bucket where export data is stored (if applicable).
     */
    public val s3SseKmsKeyId: kotlin.String? = builder.s3SseKmsKeyId
    /**
     * The time at which the export task began.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The Amazon Resource Name (ARN) of the table that was exported.
     */
    public val tableArn: kotlin.String? = builder.tableArn
    /**
     * Unique ID of the table that was exported.
     */
    public val tableId: kotlin.String? = builder.tableId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ExportDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportDescription(")
        append("billedSizeBytes=$billedSizeBytes,")
        append("clientToken=$clientToken,")
        append("endTime=$endTime,")
        append("exportArn=$exportArn,")
        append("exportFormat=$exportFormat,")
        append("exportManifest=$exportManifest,")
        append("exportStatus=$exportStatus,")
        append("exportTime=$exportTime,")
        append("exportType=$exportType,")
        append("failureCode=$failureCode,")
        append("failureMessage=$failureMessage,")
        append("incrementalExportSpecification=$incrementalExportSpecification,")
        append("itemCount=$itemCount,")
        append("s3Bucket=$s3Bucket,")
        append("s3BucketOwner=$s3BucketOwner,")
        append("s3Prefix=$s3Prefix,")
        append("s3SseAlgorithm=$s3SseAlgorithm,")
        append("s3SseKmsKeyId=$s3SseKmsKeyId,")
        append("startTime=$startTime,")
        append("tableArn=$tableArn,")
        append("tableId=$tableId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = billedSizeBytes?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (exportArn?.hashCode() ?: 0)
        result = 31 * result + (exportFormat?.hashCode() ?: 0)
        result = 31 * result + (exportManifest?.hashCode() ?: 0)
        result = 31 * result + (exportStatus?.hashCode() ?: 0)
        result = 31 * result + (exportTime?.hashCode() ?: 0)
        result = 31 * result + (exportType?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (failureMessage?.hashCode() ?: 0)
        result = 31 * result + (incrementalExportSpecification?.hashCode() ?: 0)
        result = 31 * result + (itemCount?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3BucketOwner?.hashCode() ?: 0)
        result = 31 * result + (s3Prefix?.hashCode() ?: 0)
        result = 31 * result + (s3SseAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (s3SseKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tableArn?.hashCode() ?: 0)
        result = 31 * result + (tableId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportDescription

        if (billedSizeBytes != other.billedSizeBytes) return false
        if (clientToken != other.clientToken) return false
        if (endTime != other.endTime) return false
        if (exportArn != other.exportArn) return false
        if (exportFormat != other.exportFormat) return false
        if (exportManifest != other.exportManifest) return false
        if (exportStatus != other.exportStatus) return false
        if (exportTime != other.exportTime) return false
        if (exportType != other.exportType) return false
        if (failureCode != other.failureCode) return false
        if (failureMessage != other.failureMessage) return false
        if (incrementalExportSpecification != other.incrementalExportSpecification) return false
        if (itemCount != other.itemCount) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3BucketOwner != other.s3BucketOwner) return false
        if (s3Prefix != other.s3Prefix) return false
        if (s3SseAlgorithm != other.s3SseAlgorithm) return false
        if (s3SseKmsKeyId != other.s3SseKmsKeyId) return false
        if (startTime != other.startTime) return false
        if (tableArn != other.tableArn) return false
        if (tableId != other.tableId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ExportDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The billable size of the table export.
         */
        public var billedSizeBytes: kotlin.Long? = null
        /**
         * The client token that was provided for the export task. A client token makes calls to `ExportTableToPointInTimeInput` idempotent, meaning that multiple identical calls have the same effect as one single call.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The time at which the export task completed.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the table export.
         */
        public var exportArn: kotlin.String? = null
        /**
         * The format of the exported data. Valid values for `ExportFormat` are `DYNAMODB_JSON` or `ION`.
         */
        public var exportFormat: aws.sdk.kotlin.services.dynamodb.model.ExportFormat? = null
        /**
         * The name of the manifest file for the export task.
         */
        public var exportManifest: kotlin.String? = null
        /**
         * Export can be in one of the following states: IN_PROGRESS, COMPLETED, or FAILED.
         */
        public var exportStatus: aws.sdk.kotlin.services.dynamodb.model.ExportStatus? = null
        /**
         * Point in time from which table data was exported.
         */
        public var exportTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of export that was performed. Valid values are `FULL_EXPORT` or `INCREMENTAL_EXPORT`.
         */
        public var exportType: aws.sdk.kotlin.services.dynamodb.model.ExportType? = null
        /**
         * Status code for the result of the failed export.
         */
        public var failureCode: kotlin.String? = null
        /**
         * Export failure reason description.
         */
        public var failureMessage: kotlin.String? = null
        /**
         * Optional object containing the parameters specific to an incremental export.
         */
        public var incrementalExportSpecification: aws.sdk.kotlin.services.dynamodb.model.IncrementalExportSpecification? = null
        /**
         * The number of items exported.
         */
        public var itemCount: kotlin.Long? = null
        /**
         * The name of the Amazon S3 bucket containing the export.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the bucket containing the export.
         */
        public var s3BucketOwner: kotlin.String? = null
        /**
         * The Amazon S3 bucket prefix used as the file name and path of the exported snapshot.
         */
        public var s3Prefix: kotlin.String? = null
        /**
         * Type of encryption used on the bucket where export data is stored. Valid values for `S3SseAlgorithm` are:
         * + `AES256` - server-side encryption with Amazon S3 managed keys
         * + `KMS` - server-side encryption with KMS managed keys
         */
        public var s3SseAlgorithm: aws.sdk.kotlin.services.dynamodb.model.S3SseAlgorithm? = null
        /**
         * The ID of the KMS managed key used to encrypt the S3 bucket where export data is stored (if applicable).
         */
        public var s3SseKmsKeyId: kotlin.String? = null
        /**
         * The time at which the export task began.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the table that was exported.
         */
        public var tableArn: kotlin.String? = null
        /**
         * Unique ID of the table that was exported.
         */
        public var tableId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ExportDescription) : this() {
            this.billedSizeBytes = x.billedSizeBytes
            this.clientToken = x.clientToken
            this.endTime = x.endTime
            this.exportArn = x.exportArn
            this.exportFormat = x.exportFormat
            this.exportManifest = x.exportManifest
            this.exportStatus = x.exportStatus
            this.exportTime = x.exportTime
            this.exportType = x.exportType
            this.failureCode = x.failureCode
            this.failureMessage = x.failureMessage
            this.incrementalExportSpecification = x.incrementalExportSpecification
            this.itemCount = x.itemCount
            this.s3Bucket = x.s3Bucket
            this.s3BucketOwner = x.s3BucketOwner
            this.s3Prefix = x.s3Prefix
            this.s3SseAlgorithm = x.s3SseAlgorithm
            this.s3SseKmsKeyId = x.s3SseKmsKeyId
            this.startTime = x.startTime
            this.tableArn = x.tableArn
            this.tableId = x.tableId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ExportDescription = ExportDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.IncrementalExportSpecification] inside the given [block]
         */
        public fun incrementalExportSpecification(block: aws.sdk.kotlin.services.dynamodb.model.IncrementalExportSpecification.Builder.() -> kotlin.Unit) {
            this.incrementalExportSpecification = aws.sdk.kotlin.services.dynamodb.model.IncrementalExportSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
