// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



public class ExecuteStatementRequest private constructor(builder: Builder) {
    /**
     * The consistency of a read operation. If set to `true`, then a strongly consistent read is used; otherwise, an eventually consistent read is used.
     */
    public val consistentRead: kotlin.Boolean? = builder.consistentRead
    /**
     * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, along with a key in `LastEvaluatedKey` to apply in a subsequent operation so you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in `LastEvaluatedKey` to apply in a subsequent operation to continue the operation.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * Set this value to get remaining results, if `NextToken` was returned in the statement response.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The parameters for the PartiQL statement, if any.
     */
    public val parameters: List<AttributeValue>? = builder.parameters
    /**
     * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:
     * + `INDEXES` - The response includes the aggregate `ConsumedCapacity` for the operation, together with `ConsumedCapacity` for each table and secondary index that was accessed.Note that some operations, such as `GetItem` and `BatchGetItem`, do not access any indexes at all. In these cases, specifying `INDEXES` will only return `ConsumedCapacity` information for table(s).
     * + `TOTAL` - The response includes only the aggregate `ConsumedCapacity` for the operation.
     * + `NONE` - No `ConsumedCapacity` details are included in the response.
     */
    public val returnConsumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity? = builder.returnConsumedCapacity
    /**
     * An optional parameter that returns the item attributes for an `ExecuteStatement` operation that failed a condition check.
     *
     * There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.
     */
    public val returnValuesOnConditionCheckFailure: aws.sdk.kotlin.services.dynamodb.model.ReturnValuesOnConditionCheckFailure? = builder.returnValuesOnConditionCheckFailure
    /**
     * The PartiQL statement representing the operation to run.
     */
    public val statement: kotlin.String? = builder.statement

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ExecuteStatementRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecuteStatementRequest(")
        append("consistentRead=$consistentRead,")
        append("limit=$limit,")
        append("nextToken=$nextToken,")
        append("parameters=$parameters,")
        append("returnConsumedCapacity=$returnConsumedCapacity,")
        append("returnValuesOnConditionCheckFailure=$returnValuesOnConditionCheckFailure,")
        append("statement=$statement")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = consistentRead?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (returnConsumedCapacity?.hashCode() ?: 0)
        result = 31 * result + (returnValuesOnConditionCheckFailure?.hashCode() ?: 0)
        result = 31 * result + (statement?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecuteStatementRequest

        if (consistentRead != other.consistentRead) return false
        if (limit != other.limit) return false
        if (nextToken != other.nextToken) return false
        if (parameters != other.parameters) return false
        if (returnConsumedCapacity != other.returnConsumedCapacity) return false
        if (returnValuesOnConditionCheckFailure != other.returnValuesOnConditionCheckFailure) return false
        if (statement != other.statement) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ExecuteStatementRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The consistency of a read operation. If set to `true`, then a strongly consistent read is used; otherwise, an eventually consistent read is used.
         */
        public var consistentRead: kotlin.Boolean? = null
        /**
         * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, along with a key in `LastEvaluatedKey` to apply in a subsequent operation so you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in `LastEvaluatedKey` to apply in a subsequent operation to continue the operation.
         */
        public var limit: kotlin.Int? = null
        /**
         * Set this value to get remaining results, if `NextToken` was returned in the statement response.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The parameters for the PartiQL statement, if any.
         */
        public var parameters: List<AttributeValue>? = null
        /**
         * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:
         * + `INDEXES` - The response includes the aggregate `ConsumedCapacity` for the operation, together with `ConsumedCapacity` for each table and secondary index that was accessed.Note that some operations, such as `GetItem` and `BatchGetItem`, do not access any indexes at all. In these cases, specifying `INDEXES` will only return `ConsumedCapacity` information for table(s).
         * + `TOTAL` - The response includes only the aggregate `ConsumedCapacity` for the operation.
         * + `NONE` - No `ConsumedCapacity` details are included in the response.
         */
        public var returnConsumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity? = null
        /**
         * An optional parameter that returns the item attributes for an `ExecuteStatement` operation that failed a condition check.
         *
         * There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.
         */
        public var returnValuesOnConditionCheckFailure: aws.sdk.kotlin.services.dynamodb.model.ReturnValuesOnConditionCheckFailure? = null
        /**
         * The PartiQL statement representing the operation to run.
         */
        public var statement: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ExecuteStatementRequest) : this() {
            this.consistentRead = x.consistentRead
            this.limit = x.limit
            this.nextToken = x.nextToken
            this.parameters = x.parameters
            this.returnConsumedCapacity = x.returnConsumedCapacity
            this.returnValuesOnConditionCheckFailure = x.returnValuesOnConditionCheckFailure
            this.statement = x.statement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ExecuteStatementRequest = ExecuteStatementRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
