// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * The capacity units consumed by an operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. `ConsumedCapacity` is only returned if the request asked for it. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html) in the *Amazon DynamoDB Developer Guide*.
 */
public class ConsumedCapacity private constructor(builder: Builder) {
    /**
     * The total number of capacity units consumed by the operation.
     */
    public val capacityUnits: kotlin.Double? = builder.capacityUnits
    /**
     * The amount of throughput consumed on each global index affected by the operation.
     */
    public val globalSecondaryIndexes: Map<String, Capacity>? = builder.globalSecondaryIndexes
    /**
     * The amount of throughput consumed on each local index affected by the operation.
     */
    public val localSecondaryIndexes: Map<String, Capacity>? = builder.localSecondaryIndexes
    /**
     * The total number of read capacity units consumed by the operation.
     */
    public val readCapacityUnits: kotlin.Double? = builder.readCapacityUnits
    /**
     * The amount of throughput consumed on the table affected by the operation.
     */
    public val table: aws.sdk.kotlin.services.dynamodb.model.Capacity? = builder.table
    /**
     * The name of the table that was affected by the operation.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * The total number of write capacity units consumed by the operation.
     */
    public val writeCapacityUnits: kotlin.Double? = builder.writeCapacityUnits

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConsumedCapacity(")
        append("capacityUnits=$capacityUnits,")
        append("globalSecondaryIndexes=$globalSecondaryIndexes,")
        append("localSecondaryIndexes=$localSecondaryIndexes,")
        append("readCapacityUnits=$readCapacityUnits,")
        append("table=$table,")
        append("tableName=$tableName,")
        append("writeCapacityUnits=$writeCapacityUnits")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityUnits?.hashCode() ?: 0
        result = 31 * result + (globalSecondaryIndexes?.hashCode() ?: 0)
        result = 31 * result + (localSecondaryIndexes?.hashCode() ?: 0)
        result = 31 * result + (readCapacityUnits?.hashCode() ?: 0)
        result = 31 * result + (table?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (writeCapacityUnits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConsumedCapacity

        if (capacityUnits != other.capacityUnits) return false
        if (globalSecondaryIndexes != other.globalSecondaryIndexes) return false
        if (localSecondaryIndexes != other.localSecondaryIndexes) return false
        if (readCapacityUnits != other.readCapacityUnits) return false
        if (table != other.table) return false
        if (tableName != other.tableName) return false
        if (writeCapacityUnits != other.writeCapacityUnits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total number of capacity units consumed by the operation.
         */
        public var capacityUnits: kotlin.Double? = null
        /**
         * The amount of throughput consumed on each global index affected by the operation.
         */
        public var globalSecondaryIndexes: Map<String, Capacity>? = null
        /**
         * The amount of throughput consumed on each local index affected by the operation.
         */
        public var localSecondaryIndexes: Map<String, Capacity>? = null
        /**
         * The total number of read capacity units consumed by the operation.
         */
        public var readCapacityUnits: kotlin.Double? = null
        /**
         * The amount of throughput consumed on the table affected by the operation.
         */
        public var table: aws.sdk.kotlin.services.dynamodb.model.Capacity? = null
        /**
         * The name of the table that was affected by the operation.
         */
        public var tableName: kotlin.String? = null
        /**
         * The total number of write capacity units consumed by the operation.
         */
        public var writeCapacityUnits: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity) : this() {
            this.capacityUnits = x.capacityUnits
            this.globalSecondaryIndexes = x.globalSecondaryIndexes
            this.localSecondaryIndexes = x.localSecondaryIndexes
            this.readCapacityUnits = x.readCapacityUnits
            this.table = x.table
            this.tableName = x.tableName
            this.writeCapacityUnits = x.writeCapacityUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity = ConsumedCapacity(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.Capacity] inside the given [block]
         */
        public fun table(block: aws.sdk.kotlin.services.dynamodb.model.Capacity.Builder.() -> kotlin.Unit) {
            this.table = aws.sdk.kotlin.services.dynamodb.model.Capacity.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
