// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details for the read/write capacity mode. This page talks about `PROVISIONED` and `PAY_PER_REQUEST` billing modes. For more information about these modes, see [Read/write capacity mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html).
 *
 * You may need to switch to on-demand mode at least once in order to return a `BillingModeSummary` response.
 */
public class BillingModeSummary private constructor(builder: Builder) {
    /**
     * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.
     * + `PROVISIONED` - Sets the read/write capacity mode to `PROVISIONED`. We recommend using `PROVISIONED` for predictable workloads.
     * + `PAY_PER_REQUEST` - Sets the read/write capacity mode to `PAY_PER_REQUEST`. We recommend using `PAY_PER_REQUEST` for unpredictable workloads.
     */
    public val billingMode: aws.sdk.kotlin.services.dynamodb.model.BillingMode? = builder.billingMode
    /**
     * Represents the time when `PAY_PER_REQUEST` was last set as the read/write capacity mode.
     */
    public val lastUpdateToPayPerRequestDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateToPayPerRequestDateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BillingModeSummary(")
        append("billingMode=$billingMode,")
        append("lastUpdateToPayPerRequestDateTime=$lastUpdateToPayPerRequestDateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = billingMode?.hashCode() ?: 0
        result = 31 * result + (lastUpdateToPayPerRequestDateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BillingModeSummary

        if (billingMode != other.billingMode) return false
        if (lastUpdateToPayPerRequestDateTime != other.lastUpdateToPayPerRequestDateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.
         * + `PROVISIONED` - Sets the read/write capacity mode to `PROVISIONED`. We recommend using `PROVISIONED` for predictable workloads.
         * + `PAY_PER_REQUEST` - Sets the read/write capacity mode to `PAY_PER_REQUEST`. We recommend using `PAY_PER_REQUEST` for unpredictable workloads.
         */
        public var billingMode: aws.sdk.kotlin.services.dynamodb.model.BillingMode? = null
        /**
         * Represents the time when `PAY_PER_REQUEST` was last set as the read/write capacity mode.
         */
        public var lastUpdateToPayPerRequestDateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary) : this() {
            this.billingMode = x.billingMode
            this.lastUpdateToPayPerRequestDateTime = x.lastUpdateToPayPerRequestDateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary = BillingModeSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
