// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * A PartiQL batch statement request.
 */
public class BatchStatementRequest private constructor(builder: Builder) {
    /**
     * The read consistency of the PartiQL batch request.
     */
    public val consistentRead: kotlin.Boolean? = builder.consistentRead
    /**
     * The parameters associated with a PartiQL statement in the batch request.
     */
    public val parameters: List<AttributeValue>? = builder.parameters
    /**
     * An optional parameter that returns the item attributes for a PartiQL batch request operation that failed a condition check.
     *
     * There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.
     */
    public val returnValuesOnConditionCheckFailure: aws.sdk.kotlin.services.dynamodb.model.ReturnValuesOnConditionCheckFailure? = builder.returnValuesOnConditionCheckFailure
    /**
     * A valid PartiQL statement.
     */
    public val statement: kotlin.String = requireNotNull(builder.statement) { "A non-null value must be provided for statement" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.BatchStatementRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchStatementRequest(")
        append("consistentRead=$consistentRead,")
        append("parameters=$parameters,")
        append("returnValuesOnConditionCheckFailure=$returnValuesOnConditionCheckFailure,")
        append("statement=$statement")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = consistentRead?.hashCode() ?: 0
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (returnValuesOnConditionCheckFailure?.hashCode() ?: 0)
        result = 31 * result + (statement.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchStatementRequest

        if (consistentRead != other.consistentRead) return false
        if (parameters != other.parameters) return false
        if (returnValuesOnConditionCheckFailure != other.returnValuesOnConditionCheckFailure) return false
        if (statement != other.statement) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.BatchStatementRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The read consistency of the PartiQL batch request.
         */
        public var consistentRead: kotlin.Boolean? = null
        /**
         * The parameters associated with a PartiQL statement in the batch request.
         */
        public var parameters: List<AttributeValue>? = null
        /**
         * An optional parameter that returns the item attributes for a PartiQL batch request operation that failed a condition check.
         *
         * There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.
         */
        public var returnValuesOnConditionCheckFailure: aws.sdk.kotlin.services.dynamodb.model.ReturnValuesOnConditionCheckFailure? = null
        /**
         * A valid PartiQL statement.
         */
        public var statement: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.BatchStatementRequest) : this() {
            this.consistentRead = x.consistentRead
            this.parameters = x.parameters
            this.returnValuesOnConditionCheckFailure = x.returnValuesOnConditionCheckFailure
            this.statement = x.statement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.BatchStatementRequest = BatchStatementRequest(this)

        internal fun correctErrors(): Builder {
            if (statement == null) statement = ""
            return this
        }
    }
}
