// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdbelastic.serde

import aws.sdk.kotlin.services.docdbelastic.model.RestoreClusterFromSnapshotRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class RestoreClusterFromSnapshotOperationSerializer: HttpSerializer.NonStreaming<RestoreClusterFromSnapshotRequest> {
    override fun serialize(context: ExecutionContext, input: RestoreClusterFromSnapshotRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("cluster-snapshot"))
                add(PercentEncoding.SmithyLabel.encode(input.snapshotArn))
                add(PercentEncoding.Path.encode("restore"))
            }
        }

        val payload = serializeRestoreClusterFromSnapshotOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeRestoreClusterFromSnapshotOperationBody(context: ExecutionContext, input: RestoreClusterFromSnapshotRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLUSTERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clusterName"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyId"))
    val SHARDCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("shardCapacity"))
    val SHARDINSTANCECOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("shardInstanceCount"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subnetIds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VPCSECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("vpcSecurityGroupIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTERNAME_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(SHARDCAPACITY_DESCRIPTOR)
        field(SHARDINSTANCECOUNT_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCSECURITYGROUPIDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        field(CLUSTERNAME_DESCRIPTOR, input.clusterName)
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.shardCapacity?.let { field(SHARDCAPACITY_DESCRIPTOR, it) }
        input.shardInstanceCount?.let { field(SHARDINSTANCECOUNT_DESCRIPTOR, it) }
        if (input.subnetIds != null) {
            listField(SUBNETIDS_DESCRIPTOR) {
                for (el0 in input.subnetIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        if (input.vpcSecurityGroupIds != null) {
            listField(VPCSECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.vpcSecurityGroupIds) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
