// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdbelastic.serde

import aws.sdk.kotlin.services.docdbelastic.model.CopyClusterSnapshotRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CopyClusterSnapshotOperationSerializer: HttpSerializer.NonStreaming<CopyClusterSnapshotRequest> {
    override fun serialize(context: ExecutionContext, input: CopyClusterSnapshotRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.snapshotArn) { "snapshotArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("cluster-snapshot"))
                add(PercentEncoding.SmithyLabel.encode(input.snapshotArn))
                add(PercentEncoding.Path.encode("copy"))
            }
        }

        val payload = serializeCopyClusterSnapshotOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCopyClusterSnapshotOperationBody(context: ExecutionContext, input: CopyClusterSnapshotRequest): ByteArray {
    val serializer = JsonSerializer()
    val COPYTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("copyTags"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TARGETSNAPSHOTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetSnapshotName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COPYTAGS_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TARGETSNAPSHOTNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.copyTags?.let { field(COPYTAGS_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.targetSnapshotName?.let { field(TARGETSNAPSHOTNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
