// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdbelastic.paginators

import aws.sdk.kotlin.services.docdbelastic.DocDbElasticClient
import aws.sdk.kotlin.services.docdbelastic.model.ClusterInList
import aws.sdk.kotlin.services.docdbelastic.model.ClusterSnapshotInList
import aws.sdk.kotlin.services.docdbelastic.model.ListClusterSnapshotsRequest
import aws.sdk.kotlin.services.docdbelastic.model.ListClusterSnapshotsResponse
import aws.sdk.kotlin.services.docdbelastic.model.ListClustersRequest
import aws.sdk.kotlin.services.docdbelastic.model.ListClustersResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun DocDbElasticClient.listClustersPaginated(initialRequest: ListClustersRequest = ListClustersRequest { }): Flow<ListClustersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClustersPaginated.listClusters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun DocDbElasticClient.listClustersPaginated(block: ListClustersRequest.Builder.() -> Unit): Flow<ListClustersResponse> =
    listClustersPaginated(ListClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClustersPaginated]
 * to access the nested member [ClusterInList]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterInList]
 */
@JvmName("listClustersResponseClusterInList")
public fun Flow<ListClustersResponse>.clusters(): Flow<ClusterInList> =
    transform() { response ->
        response.clusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClusterSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClusterSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClusterSnapshotsResponse]
 */
public fun DocDbElasticClient.listClusterSnapshotsPaginated(initialRequest: ListClusterSnapshotsRequest = ListClusterSnapshotsRequest { }): Flow<ListClusterSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClusterSnapshotsPaginated.listClusterSnapshots(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClusterSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClusterSnapshotsResponse]
 */
public fun DocDbElasticClient.listClusterSnapshotsPaginated(block: ListClusterSnapshotsRequest.Builder.() -> Unit): Flow<ListClusterSnapshotsResponse> =
    listClusterSnapshotsPaginated(ListClusterSnapshotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClusterSnapshotsPaginated]
 * to access the nested member [ClusterSnapshotInList]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterSnapshotInList]
 */
@JvmName("listClusterSnapshotsResponseClusterSnapshotInList")
public fun Flow<ListClusterSnapshotsResponse>.snapshots(): Flow<ClusterSnapshotInList> =
    transform() { response ->
        response.snapshots?.forEach {
            emit(it)
        }
    }
