// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdbelastic.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * A structure defining a validation exception.
 */
public class ValidationException private constructor(builder: Builder) : DocDbElasticException(builder.message) {

    /**
     * A list of the fields in which the validation exception occurred.
     */
    public val fieldList: List<ValidationExceptionField>? = builder.fieldList
    /**
     * The reason why the validation exception occurred (one of `unknownOperation`, `cannotParse`, `fieldValidationFailed`, or `other`).
     */
    public val reason: aws.sdk.kotlin.services.docdbelastic.model.ValidationExceptionReason = requireNotNull(builder.reason) { "A non-null value must be provided for reason" }

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdbelastic.model.ValidationException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidationException(")
        append("fieldList=$fieldList,")
        append("message=$message,")
        append("reason=$reason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldList?.hashCode() ?: 0
        result = 31 * result + (message.hashCode())
        result = 31 * result + (reason.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidationException

        if (fieldList != other.fieldList) return false
        if (message != other.message) return false
        if (reason != other.reason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdbelastic.model.ValidationException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of the fields in which the validation exception occurred.
         */
        public var fieldList: List<ValidationExceptionField>? = null
        /**
         * An error message describing the validation exception.
         */
        public var message: kotlin.String? = null
        /**
         * The reason why the validation exception occurred (one of `unknownOperation`, `cannotParse`, `fieldValidationFailed`, or `other`).
         */
        public var reason: aws.sdk.kotlin.services.docdbelastic.model.ValidationExceptionReason? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdbelastic.model.ValidationException) : this() {
            this.fieldList = x.fieldList
            this.message = x.message
            this.reason = x.reason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdbelastic.model.ValidationException = ValidationException(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            if (reason == null) reason = ValidationExceptionReason.SdkUnknown("no value provided")
            return this
        }
    }
}
