// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdbelastic.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateClusterRequest private constructor(builder: Builder) {
    /**
     * The password associated with the elastic cluster administrator. This password can contain any printable ASCII character except forward slash (/), double quote ("), or the "at" symbol (@).
     *
     * *Constraints*: Must contain from 8 to 100 characters.
     */
    public val adminUserPassword: kotlin.String? = builder.adminUserPassword
    /**
     * The authentication type used to determine where to fetch the password used for accessing the elastic cluster. Valid types are `PLAIN_TEXT` or `SECRET_ARN`.
     */
    public val authType: aws.sdk.kotlin.services.docdbelastic.model.Auth? = builder.authType
    /**
     * The number of days for which automatic snapshots are retained.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The client token for the elastic cluster.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The ARN identifier of the elastic cluster.
     */
    public val clusterArn: kotlin.String = requireNotNull(builder.clusterArn) { "A non-null value must be provided for clusterArn" }
    /**
     * The daily time range during which automated backups are created if automated backups are enabled, as determined by the `backupRetentionPeriod`.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *
     * *Format*: `ddd:hh24:mi-ddd:hh24:mi`
     *
     * *Default*: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.
     *
     * *Valid days*: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     *
     * *Constraints*: Minimum 30-minute window.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64.
     */
    public val shardCapacity: kotlin.Int? = builder.shardCapacity
    /**
     * The number of shards assigned to the elastic cluster. Maximum is 32.
     */
    public val shardCount: kotlin.Int? = builder.shardCount
    /**
     * The number of replica instances applying to all shards in the elastic cluster. A `shardInstanceCount` value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.
     */
    public val shardInstanceCount: kotlin.Int? = builder.shardInstanceCount
    /**
     * The Amazon EC2 subnet IDs for the elastic cluster.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * A list of EC2 VPC security groups to associate with the elastic cluster.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdbelastic.model.UpdateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateClusterRequest(")
        append("adminUserPassword=*** Sensitive Data Redacted ***,")
        append("authType=$authType,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("clientToken=$clientToken,")
        append("clusterArn=$clusterArn,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("shardCapacity=$shardCapacity,")
        append("shardCount=$shardCount,")
        append("shardInstanceCount=$shardInstanceCount,")
        append("subnetIds=$subnetIds,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adminUserPassword?.hashCode() ?: 0
        result = 31 * result + (authType?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (clusterArn.hashCode())
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (shardCapacity ?: 0)
        result = 31 * result + (shardCount ?: 0)
        result = 31 * result + (shardInstanceCount ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateClusterRequest

        if (adminUserPassword != other.adminUserPassword) return false
        if (authType != other.authType) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (clientToken != other.clientToken) return false
        if (clusterArn != other.clusterArn) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (shardCapacity != other.shardCapacity) return false
        if (shardCount != other.shardCount) return false
        if (shardInstanceCount != other.shardInstanceCount) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdbelastic.model.UpdateClusterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The password associated with the elastic cluster administrator. This password can contain any printable ASCII character except forward slash (/), double quote ("), or the "at" symbol (@).
         *
         * *Constraints*: Must contain from 8 to 100 characters.
         */
        public var adminUserPassword: kotlin.String? = null
        /**
         * The authentication type used to determine where to fetch the password used for accessing the elastic cluster. Valid types are `PLAIN_TEXT` or `SECRET_ARN`.
         */
        public var authType: aws.sdk.kotlin.services.docdbelastic.model.Auth? = null
        /**
         * The number of days for which automatic snapshots are retained.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The client token for the elastic cluster.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The ARN identifier of the elastic cluster.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled, as determined by the `backupRetentionPeriod`.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *
         * *Format*: `ddd:hh24:mi-ddd:hh24:mi`
         *
         * *Default*: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.
         *
         * *Valid days*: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         *
         * *Constraints*: Minimum 30-minute window.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64.
         */
        public var shardCapacity: kotlin.Int? = null
        /**
         * The number of shards assigned to the elastic cluster. Maximum is 32.
         */
        public var shardCount: kotlin.Int? = null
        /**
         * The number of replica instances applying to all shards in the elastic cluster. A `shardInstanceCount` value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.
         */
        public var shardInstanceCount: kotlin.Int? = null
        /**
         * The Amazon EC2 subnet IDs for the elastic cluster.
         */
        public var subnetIds: List<String>? = null
        /**
         * A list of EC2 VPC security groups to associate with the elastic cluster.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdbelastic.model.UpdateClusterRequest) : this() {
            this.adminUserPassword = x.adminUserPassword
            this.authType = x.authType
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.clientToken = x.clientToken
            this.clusterArn = x.clusterArn
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.shardCapacity = x.shardCapacity
            this.shardCount = x.shardCount
            this.shardInstanceCount = x.shardInstanceCount
            this.subnetIds = x.subnetIds
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdbelastic.model.UpdateClusterRequest = UpdateClusterRequest(this)

        internal fun correctErrors(): Builder {
            if (clusterArn == null) clusterArn = ""
            return this
        }
    }
}
