// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdbelastic.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RestoreClusterFromSnapshotRequest private constructor(builder: Builder) {
    /**
     * The name of the elastic cluster.
     */
    public val clusterName: kotlin.String = requireNotNull(builder.clusterName) { "A non-null value must be provided for clusterName" }
    /**
     * The KMS key identifier to use to encrypt the new Amazon DocumentDB elastic clusters cluster.
     *
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS encryption key.
     *
     * If an encryption key is not specified here, Amazon DocumentDB uses the default encryption key that KMS creates for your account. Your account has a different default encryption key for each Amazon Region.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The capacity of each shard in the new restored elastic cluster.
     */
    public val shardCapacity: kotlin.Int? = builder.shardCapacity
    /**
     * The number of replica instances applying to all shards in the elastic cluster. A `shardInstanceCount` value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.
     */
    public val shardInstanceCount: kotlin.Int? = builder.shardInstanceCount
    /**
     * The ARN identifier of the elastic cluster snapshot.
     */
    public val snapshotArn: kotlin.String = requireNotNull(builder.snapshotArn) { "A non-null value must be provided for snapshotArn" }
    /**
     * The Amazon EC2 subnet IDs for the elastic cluster.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * A list of the tag names to be assigned to the restored elastic cluster, in the form of an array of key-value pairs in which the key is the tag name and the value is the key value.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A list of EC2 VPC security groups to associate with the elastic cluster.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdbelastic.model.RestoreClusterFromSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreClusterFromSnapshotRequest(")
        append("clusterName=$clusterName,")
        append("kmsKeyId=$kmsKeyId,")
        append("shardCapacity=$shardCapacity,")
        append("shardInstanceCount=$shardInstanceCount,")
        append("snapshotArn=$snapshotArn,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName.hashCode()
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (shardCapacity ?: 0)
        result = 31 * result + (shardInstanceCount ?: 0)
        result = 31 * result + (snapshotArn.hashCode())
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreClusterFromSnapshotRequest

        if (clusterName != other.clusterName) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (shardCapacity != other.shardCapacity) return false
        if (shardInstanceCount != other.shardInstanceCount) return false
        if (snapshotArn != other.snapshotArn) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdbelastic.model.RestoreClusterFromSnapshotRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the elastic cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The KMS key identifier to use to encrypt the new Amazon DocumentDB elastic clusters cluster.
         *
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS encryption key.
         *
         * If an encryption key is not specified here, Amazon DocumentDB uses the default encryption key that KMS creates for your account. Your account has a different default encryption key for each Amazon Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The capacity of each shard in the new restored elastic cluster.
         */
        public var shardCapacity: kotlin.Int? = null
        /**
         * The number of replica instances applying to all shards in the elastic cluster. A `shardInstanceCount` value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.
         */
        public var shardInstanceCount: kotlin.Int? = null
        /**
         * The ARN identifier of the elastic cluster snapshot.
         */
        public var snapshotArn: kotlin.String? = null
        /**
         * The Amazon EC2 subnet IDs for the elastic cluster.
         */
        public var subnetIds: List<String>? = null
        /**
         * A list of the tag names to be assigned to the restored elastic cluster, in the form of an array of key-value pairs in which the key is the tag name and the value is the key value.
         */
        public var tags: Map<String, String>? = null
        /**
         * A list of EC2 VPC security groups to associate with the elastic cluster.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdbelastic.model.RestoreClusterFromSnapshotRequest) : this() {
            this.clusterName = x.clusterName
            this.kmsKeyId = x.kmsKeyId
            this.shardCapacity = x.shardCapacity
            this.shardInstanceCount = x.shardInstanceCount
            this.snapshotArn = x.snapshotArn
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdbelastic.model.RestoreClusterFromSnapshotRequest = RestoreClusterFromSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            if (clusterName == null) clusterName = ""
            if (snapshotArn == null) snapshotArn = ""
            return this
        }
    }
}
