// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdbelastic.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateClusterRequest private constructor(builder: Builder) {
    /**
     * The name of the Amazon DocumentDB elastic clusters administrator.
     *
     * *Constraints*:
     * + Must be from 1 to 63 letters or numbers.
     * + The first character must be a letter.
     * + Cannot be a reserved word.
     */
    public val adminUserName: kotlin.String = requireNotNull(builder.adminUserName) { "A non-null value must be provided for adminUserName" }
    /**
     * The password for the Amazon DocumentDB elastic clusters administrator. The password can contain any printable ASCII characters.
     *
     * *Constraints*:
     * + Must contain from 8 to 100 characters.
     * + Cannot contain a forward slash (/), double quote ("), or the "at" symbol (@).
     */
    public val adminUserPassword: kotlin.String = requireNotNull(builder.adminUserPassword) { "A non-null value must be provided for adminUserPassword" }
    /**
     * The authentication type used to determine where to fetch the password used for accessing the elastic cluster. Valid types are `PLAIN_TEXT` or `SECRET_ARN`.
     */
    public val authType: aws.sdk.kotlin.services.docdbelastic.model.Auth = requireNotNull(builder.authType) { "A non-null value must be provided for authType" }
    /**
     * The number of days for which automatic snapshots are retained.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The client token for the elastic cluster.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the new elastic cluster. This parameter is stored as a lowercase string.
     *
     * *Constraints*:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + The first character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     *
     * *Example*: `my-cluster`
     */
    public val clusterName: kotlin.String = requireNotNull(builder.clusterName) { "A non-null value must be provided for clusterName" }
    /**
     * The KMS key identifier to use to encrypt the new elastic cluster.
     *
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS encryption key.
     *
     * If an encryption key is not specified, Amazon DocumentDB uses the default encryption key that KMS creates for your account. Your account has a different default encryption key for each Amazon Region.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The daily time range during which automated backups are created if automated backups are enabled, as determined by the `backupRetentionPeriod`.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *
     * *Format*: `ddd:hh24:mi-ddd:hh24:mi`
     *
     * *Default*: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.
     *
     * *Valid days*: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     *
     * *Constraints*: Minimum 30-minute window.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64.
     */
    public val shardCapacity: kotlin.Int = requireNotNull(builder.shardCapacity) { "A non-null value must be provided for shardCapacity" }
    /**
     * The number of shards assigned to the elastic cluster. Maximum is 32.
     */
    public val shardCount: kotlin.Int = requireNotNull(builder.shardCount) { "A non-null value must be provided for shardCount" }
    /**
     * The number of replica instances applying to all shards in the elastic cluster. A `shardInstanceCount` value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.
     */
    public val shardInstanceCount: kotlin.Int? = builder.shardInstanceCount
    /**
     * The Amazon EC2 subnet IDs for the new elastic cluster.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The tags to be assigned to the new elastic cluster.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A list of EC2 VPC security groups to associate with the new elastic cluster.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdbelastic.model.CreateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterRequest(")
        append("adminUserName=$adminUserName,")
        append("adminUserPassword=*** Sensitive Data Redacted ***,")
        append("authType=$authType,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("clientToken=$clientToken,")
        append("clusterName=$clusterName,")
        append("kmsKeyId=$kmsKeyId,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("shardCapacity=$shardCapacity,")
        append("shardCount=$shardCount,")
        append("shardInstanceCount=$shardInstanceCount,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adminUserName.hashCode()
        result = 31 * result + (adminUserPassword.hashCode())
        result = 31 * result + (authType.hashCode())
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (clusterName.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (shardCapacity)
        result = 31 * result + (shardCount)
        result = 31 * result + (shardInstanceCount ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClusterRequest

        if (adminUserName != other.adminUserName) return false
        if (adminUserPassword != other.adminUserPassword) return false
        if (authType != other.authType) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (clientToken != other.clientToken) return false
        if (clusterName != other.clusterName) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (shardCapacity != other.shardCapacity) return false
        if (shardCount != other.shardCount) return false
        if (shardInstanceCount != other.shardInstanceCount) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdbelastic.model.CreateClusterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Amazon DocumentDB elastic clusters administrator.
         *
         * *Constraints*:
         * + Must be from 1 to 63 letters or numbers.
         * + The first character must be a letter.
         * + Cannot be a reserved word.
         */
        public var adminUserName: kotlin.String? = null
        /**
         * The password for the Amazon DocumentDB elastic clusters administrator. The password can contain any printable ASCII characters.
         *
         * *Constraints*:
         * + Must contain from 8 to 100 characters.
         * + Cannot contain a forward slash (/), double quote ("), or the "at" symbol (@).
         */
        public var adminUserPassword: kotlin.String? = null
        /**
         * The authentication type used to determine where to fetch the password used for accessing the elastic cluster. Valid types are `PLAIN_TEXT` or `SECRET_ARN`.
         */
        public var authType: aws.sdk.kotlin.services.docdbelastic.model.Auth? = null
        /**
         * The number of days for which automatic snapshots are retained.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The client token for the elastic cluster.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the new elastic cluster. This parameter is stored as a lowercase string.
         *
         * *Constraints*:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + The first character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         *
         * *Example*: `my-cluster`
         */
        public var clusterName: kotlin.String? = null
        /**
         * The KMS key identifier to use to encrypt the new elastic cluster.
         *
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS encryption key.
         *
         * If an encryption key is not specified, Amazon DocumentDB uses the default encryption key that KMS creates for your account. Your account has a different default encryption key for each Amazon Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled, as determined by the `backupRetentionPeriod`.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *
         * *Format*: `ddd:hh24:mi-ddd:hh24:mi`
         *
         * *Default*: a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.
         *
         * *Valid days*: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         *
         * *Constraints*: Minimum 30-minute window.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64.
         */
        public var shardCapacity: kotlin.Int? = null
        /**
         * The number of shards assigned to the elastic cluster. Maximum is 32.
         */
        public var shardCount: kotlin.Int? = null
        /**
         * The number of replica instances applying to all shards in the elastic cluster. A `shardInstanceCount` value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.
         */
        public var shardInstanceCount: kotlin.Int? = null
        /**
         * The Amazon EC2 subnet IDs for the new elastic cluster.
         */
        public var subnetIds: List<String>? = null
        /**
         * The tags to be assigned to the new elastic cluster.
         */
        public var tags: Map<String, String>? = null
        /**
         * A list of EC2 VPC security groups to associate with the new elastic cluster.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdbelastic.model.CreateClusterRequest) : this() {
            this.adminUserName = x.adminUserName
            this.adminUserPassword = x.adminUserPassword
            this.authType = x.authType
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.clientToken = x.clientToken
            this.clusterName = x.clusterName
            this.kmsKeyId = x.kmsKeyId
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.shardCapacity = x.shardCapacity
            this.shardCount = x.shardCount
            this.shardInstanceCount = x.shardInstanceCount
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdbelastic.model.CreateClusterRequest = CreateClusterRequest(this)

        internal fun correctErrors(): Builder {
            if (adminUserName == null) adminUserName = ""
            if (adminUserPassword == null) adminUserPassword = ""
            if (authType == null) authType = Auth.SdkUnknown("no value provided")
            if (clusterName == null) clusterName = ""
            if (shardCapacity == null) shardCapacity = 0
            if (shardCount == null) shardCount = 0
            return this
        }
    }
}
