// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdbelastic.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CopyClusterSnapshotRequest private constructor(builder: Builder) {
    /**
     * Set to `true` to copy all tags from the source cluster snapshot to the target elastic cluster snapshot. The default is `false`.
     */
    public val copyTags: kotlin.Boolean? = builder.copyTags
    /**
     * The Amazon Web Services KMS key ID for an encrypted elastic cluster snapshot. The Amazon Web Services KMS key ID is the Amazon Resource Name (ARN), Amazon Web Services KMS key identifier, or the Amazon Web Services KMS key alias for the Amazon Web Services KMS encryption key.
     *
     * If you copy an encrypted elastic cluster snapshot from your Amazon Web Services account, you can specify a value for `KmsKeyId` to encrypt the copy with a new Amazon Web ServicesS KMS encryption key. If you don't specify a value for `KmsKeyId`, then the copy of the elastic cluster snapshot is encrypted with the same `AWS` KMS key as the source elastic cluster snapshot.
     *
     * To copy an encrypted elastic cluster snapshot to another Amazon Web Services region, set `KmsKeyId` to the Amazon Web Services KMS key ID that you want to use to encrypt the copy of the elastic cluster snapshot in the destination region. Amazon Web Services KMS encryption keys are specific to the Amazon Web Services region that they are created in, and you can't use encryption keys from one Amazon Web Services region in another Amazon Web Services region.
     *
     * If you copy an unencrypted elastic cluster snapshot and specify a value for the `KmsKeyId` parameter, an error is returned.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon Resource Name (ARN) identifier of the elastic cluster snapshot.
     */
    public val snapshotArn: kotlin.String? = builder.snapshotArn
    /**
     * The tags to be assigned to the elastic cluster snapshot.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The identifier of the new elastic cluster snapshot to create from the source cluster snapshot. This parameter is not case sensitive.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + The first character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `elastic-cluster-snapshot-5`
     */
    public val targetSnapshotName: kotlin.String? = builder.targetSnapshotName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdbelastic.model.CopyClusterSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyClusterSnapshotRequest(")
        append("copyTags=$copyTags,")
        append("kmsKeyId=$kmsKeyId,")
        append("snapshotArn=$snapshotArn,")
        append("tags=$tags,")
        append("targetSnapshotName=$targetSnapshotName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTags?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (snapshotArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetSnapshotName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyClusterSnapshotRequest

        if (copyTags != other.copyTags) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (snapshotArn != other.snapshotArn) return false
        if (tags != other.tags) return false
        if (targetSnapshotName != other.targetSnapshotName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdbelastic.model.CopyClusterSnapshotRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Set to `true` to copy all tags from the source cluster snapshot to the target elastic cluster snapshot. The default is `false`.
         */
        public var copyTags: kotlin.Boolean? = null
        /**
         * The Amazon Web Services KMS key ID for an encrypted elastic cluster snapshot. The Amazon Web Services KMS key ID is the Amazon Resource Name (ARN), Amazon Web Services KMS key identifier, or the Amazon Web Services KMS key alias for the Amazon Web Services KMS encryption key.
         *
         * If you copy an encrypted elastic cluster snapshot from your Amazon Web Services account, you can specify a value for `KmsKeyId` to encrypt the copy with a new Amazon Web ServicesS KMS encryption key. If you don't specify a value for `KmsKeyId`, then the copy of the elastic cluster snapshot is encrypted with the same `AWS` KMS key as the source elastic cluster snapshot.
         *
         * To copy an encrypted elastic cluster snapshot to another Amazon Web Services region, set `KmsKeyId` to the Amazon Web Services KMS key ID that you want to use to encrypt the copy of the elastic cluster snapshot in the destination region. Amazon Web Services KMS encryption keys are specific to the Amazon Web Services region that they are created in, and you can't use encryption keys from one Amazon Web Services region in another Amazon Web Services region.
         *
         * If you copy an unencrypted elastic cluster snapshot and specify a value for the `KmsKeyId` parameter, an error is returned.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) identifier of the elastic cluster snapshot.
         */
        public var snapshotArn: kotlin.String? = null
        /**
         * The tags to be assigned to the elastic cluster snapshot.
         */
        public var tags: Map<String, String>? = null
        /**
         * The identifier of the new elastic cluster snapshot to create from the source cluster snapshot. This parameter is not case sensitive.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + The first character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `elastic-cluster-snapshot-5`
         */
        public var targetSnapshotName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdbelastic.model.CopyClusterSnapshotRequest) : this() {
            this.copyTags = x.copyTags
            this.kmsKeyId = x.kmsKeyId
            this.snapshotArn = x.snapshotArn
            this.tags = x.tags
            this.targetSnapshotName = x.targetSnapshotName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdbelastic.model.CopyClusterSnapshotRequest = CopyClusterSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
