// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdbelastic.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Returns information about a specific elastic cluster snapshot.
 */
public class ClusterSnapshot private constructor(builder: Builder) {
    /**
     * The name of the elastic cluster administrator.
     */
    public val adminUserName: kotlin.String = requireNotNull(builder.adminUserName) { "A non-null value must be provided for adminUserName" }
    /**
     * The ARN identifier of the elastic cluster.
     */
    public val clusterArn: kotlin.String = requireNotNull(builder.clusterArn) { "A non-null value must be provided for clusterArn" }
    /**
     * The time when the elastic cluster was created in Universal Coordinated Time (UTC).
     */
    public val clusterCreationTime: kotlin.String = requireNotNull(builder.clusterCreationTime) { "A non-null value must be provided for clusterCreationTime" }
    /**
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS encryption key. If an encryption key is not specified here, Amazon DocumentDB uses the default encryption key that KMS creates for your account. Your account has a different default encryption key for each Amazon Region.
     */
    public val kmsKeyId: kotlin.String = requireNotNull(builder.kmsKeyId) { "A non-null value must be provided for kmsKeyId" }
    /**
     * The ARN identifier of the elastic cluster snapshot.
     */
    public val snapshotArn: kotlin.String = requireNotNull(builder.snapshotArn) { "A non-null value must be provided for snapshotArn" }
    /**
     * The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).
     */
    public val snapshotCreationTime: kotlin.String = requireNotNull(builder.snapshotCreationTime) { "A non-null value must be provided for snapshotCreationTime" }
    /**
     * The name of the elastic cluster snapshot.
     */
    public val snapshotName: kotlin.String = requireNotNull(builder.snapshotName) { "A non-null value must be provided for snapshotName" }
    /**
     * The type of cluster snapshots to be returned. You can specify one of the following values:
     * + `automated` - Return all cluster snapshots that Amazon DocumentDB has automatically created for your Amazon Web Services account.
     * + `manual` - Return all cluster snapshots that you have manually created for your Amazon Web Services account.
     */
    public val snapshotType: aws.sdk.kotlin.services.docdbelastic.model.SnapshotType? = builder.snapshotType
    /**
     * The status of the elastic cluster snapshot.
     */
    public val status: aws.sdk.kotlin.services.docdbelastic.model.Status = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The Amazon EC2 subnet IDs for the elastic cluster.
     */
    public val subnetIds: List<String> = requireNotNull(builder.subnetIds) { "A non-null value must be provided for subnetIds" }
    /**
     * A list of EC2 VPC security groups to associate with the elastic cluster.
     */
    public val vpcSecurityGroupIds: List<String> = requireNotNull(builder.vpcSecurityGroupIds) { "A non-null value must be provided for vpcSecurityGroupIds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdbelastic.model.ClusterSnapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterSnapshot(")
        append("adminUserName=$adminUserName,")
        append("clusterArn=$clusterArn,")
        append("clusterCreationTime=$clusterCreationTime,")
        append("kmsKeyId=$kmsKeyId,")
        append("snapshotArn=$snapshotArn,")
        append("snapshotCreationTime=$snapshotCreationTime,")
        append("snapshotName=$snapshotName,")
        append("snapshotType=$snapshotType,")
        append("status=$status,")
        append("subnetIds=$subnetIds,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adminUserName.hashCode()
        result = 31 * result + (clusterArn.hashCode())
        result = 31 * result + (clusterCreationTime.hashCode())
        result = 31 * result + (kmsKeyId.hashCode())
        result = 31 * result + (snapshotArn.hashCode())
        result = 31 * result + (snapshotCreationTime.hashCode())
        result = 31 * result + (snapshotName.hashCode())
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (subnetIds.hashCode())
        result = 31 * result + (vpcSecurityGroupIds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterSnapshot

        if (adminUserName != other.adminUserName) return false
        if (clusterArn != other.clusterArn) return false
        if (clusterCreationTime != other.clusterCreationTime) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (snapshotArn != other.snapshotArn) return false
        if (snapshotCreationTime != other.snapshotCreationTime) return false
        if (snapshotName != other.snapshotName) return false
        if (snapshotType != other.snapshotType) return false
        if (status != other.status) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdbelastic.model.ClusterSnapshot = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the elastic cluster administrator.
         */
        public var adminUserName: kotlin.String? = null
        /**
         * The ARN identifier of the elastic cluster.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The time when the elastic cluster was created in Universal Coordinated Time (UTC).
         */
        public var clusterCreationTime: kotlin.String? = null
        /**
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same Amazon account that owns this KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS encryption key. If an encryption key is not specified here, Amazon DocumentDB uses the default encryption key that KMS creates for your account. Your account has a different default encryption key for each Amazon Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The ARN identifier of the elastic cluster snapshot.
         */
        public var snapshotArn: kotlin.String? = null
        /**
         * The time when the elastic cluster snapshot was created in Universal Coordinated Time (UTC).
         */
        public var snapshotCreationTime: kotlin.String? = null
        /**
         * The name of the elastic cluster snapshot.
         */
        public var snapshotName: kotlin.String? = null
        /**
         * The type of cluster snapshots to be returned. You can specify one of the following values:
         * + `automated` - Return all cluster snapshots that Amazon DocumentDB has automatically created for your Amazon Web Services account.
         * + `manual` - Return all cluster snapshots that you have manually created for your Amazon Web Services account.
         */
        public var snapshotType: aws.sdk.kotlin.services.docdbelastic.model.SnapshotType? = null
        /**
         * The status of the elastic cluster snapshot.
         */
        public var status: aws.sdk.kotlin.services.docdbelastic.model.Status? = null
        /**
         * The Amazon EC2 subnet IDs for the elastic cluster.
         */
        public var subnetIds: List<String>? = null
        /**
         * A list of EC2 VPC security groups to associate with the elastic cluster.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdbelastic.model.ClusterSnapshot) : this() {
            this.adminUserName = x.adminUserName
            this.clusterArn = x.clusterArn
            this.clusterCreationTime = x.clusterCreationTime
            this.kmsKeyId = x.kmsKeyId
            this.snapshotArn = x.snapshotArn
            this.snapshotCreationTime = x.snapshotCreationTime
            this.snapshotName = x.snapshotName
            this.snapshotType = x.snapshotType
            this.status = x.status
            this.subnetIds = x.subnetIds
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdbelastic.model.ClusterSnapshot = ClusterSnapshot(this)

        internal fun correctErrors(): Builder {
            if (adminUserName == null) adminUserName = ""
            if (clusterArn == null) clusterArn = ""
            if (clusterCreationTime == null) clusterCreationTime = ""
            if (kmsKeyId == null) kmsKeyId = ""
            if (snapshotArn == null) snapshotArn = ""
            if (snapshotCreationTime == null) snapshotCreationTime = ""
            if (snapshotName == null) snapshotName = ""
            if (status == null) status = Status.SdkUnknown("no value provided")
            if (subnetIds == null) subnetIds = emptyList()
            if (vpcSecurityGroupIds == null) vpcSecurityGroupIds = emptyList()
            return this
        }
    }
}
