// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdbelastic.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Returns information about a specific elastic cluster.
 */
public class Cluster private constructor(builder: Builder) {
    /**
     * The name of the elastic cluster administrator.
     */
    public val adminUserName: kotlin.String = requireNotNull(builder.adminUserName) { "A non-null value must be provided for adminUserName" }
    /**
     * The authentication type for the elastic cluster.
     */
    public val authType: aws.sdk.kotlin.services.docdbelastic.model.Auth = requireNotNull(builder.authType) { "A non-null value must be provided for authType" }
    /**
     * The number of days for which automatic snapshots are retained.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The ARN identifier of the elastic cluster.
     */
    public val clusterArn: kotlin.String = requireNotNull(builder.clusterArn) { "A non-null value must be provided for clusterArn" }
    /**
     * The URL used to connect to the elastic cluster.
     */
    public val clusterEndpoint: kotlin.String = requireNotNull(builder.clusterEndpoint) { "A non-null value must be provided for clusterEndpoint" }
    /**
     * The name of the elastic cluster.
     */
    public val clusterName: kotlin.String = requireNotNull(builder.clusterName) { "A non-null value must be provided for clusterName" }
    /**
     * The time when the elastic cluster was created in Universal Coordinated Time (UTC).
     */
    public val createTime: kotlin.String = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The KMS key identifier to use to encrypt the elastic cluster.
     */
    public val kmsKeyId: kotlin.String = requireNotNull(builder.kmsKeyId) { "A non-null value must be provided for kmsKeyId" }
    /**
     * The daily time range during which automated backups are created if automated backups are enabled, as determined by `backupRetentionPeriod`.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *
     * *Format*: `ddd:hh24:mi-ddd:hh24:mi`
     */
    public val preferredMaintenanceWindow: kotlin.String = requireNotNull(builder.preferredMaintenanceWindow) { "A non-null value must be provided for preferredMaintenanceWindow" }
    /**
     * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64.
     */
    public val shardCapacity: kotlin.Int = requireNotNull(builder.shardCapacity) { "A non-null value must be provided for shardCapacity" }
    /**
     * The number of shards assigned to the elastic cluster. Maximum is 32.
     */
    public val shardCount: kotlin.Int = requireNotNull(builder.shardCount) { "A non-null value must be provided for shardCount" }
    /**
     * The number of replica instances applying to all shards in the cluster. A `shardInstanceCount` value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.
     */
    public val shardInstanceCount: kotlin.Int? = builder.shardInstanceCount
    /**
     * The total number of shards in the cluster.
     */
    public val shards: List<Shard>? = builder.shards
    /**
     * The status of the elastic cluster.
     */
    public val status: aws.sdk.kotlin.services.docdbelastic.model.Status = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The Amazon EC2 subnet IDs for the elastic cluster.
     */
    public val subnetIds: List<String> = requireNotNull(builder.subnetIds) { "A non-null value must be provided for subnetIds" }
    /**
     * A list of EC2 VPC security groups associated with thie elastic cluster.
     */
    public val vpcSecurityGroupIds: List<String> = requireNotNull(builder.vpcSecurityGroupIds) { "A non-null value must be provided for vpcSecurityGroupIds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.docdbelastic.model.Cluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cluster(")
        append("adminUserName=$adminUserName,")
        append("authType=$authType,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("clusterArn=$clusterArn,")
        append("clusterEndpoint=$clusterEndpoint,")
        append("clusterName=$clusterName,")
        append("createTime=$createTime,")
        append("kmsKeyId=$kmsKeyId,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("shardCapacity=$shardCapacity,")
        append("shardCount=$shardCount,")
        append("shardInstanceCount=$shardInstanceCount,")
        append("shards=$shards,")
        append("status=$status,")
        append("subnetIds=$subnetIds,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adminUserName.hashCode()
        result = 31 * result + (authType.hashCode())
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (clusterArn.hashCode())
        result = 31 * result + (clusterEndpoint.hashCode())
        result = 31 * result + (clusterName.hashCode())
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (kmsKeyId.hashCode())
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow.hashCode())
        result = 31 * result + (shardCapacity)
        result = 31 * result + (shardCount)
        result = 31 * result + (shardInstanceCount ?: 0)
        result = 31 * result + (shards?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (subnetIds.hashCode())
        result = 31 * result + (vpcSecurityGroupIds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cluster

        if (adminUserName != other.adminUserName) return false
        if (authType != other.authType) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (clusterArn != other.clusterArn) return false
        if (clusterEndpoint != other.clusterEndpoint) return false
        if (clusterName != other.clusterName) return false
        if (createTime != other.createTime) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (shardCapacity != other.shardCapacity) return false
        if (shardCount != other.shardCount) return false
        if (shardInstanceCount != other.shardInstanceCount) return false
        if (shards != other.shards) return false
        if (status != other.status) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.docdbelastic.model.Cluster = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the elastic cluster administrator.
         */
        public var adminUserName: kotlin.String? = null
        /**
         * The authentication type for the elastic cluster.
         */
        public var authType: aws.sdk.kotlin.services.docdbelastic.model.Auth? = null
        /**
         * The number of days for which automatic snapshots are retained.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The ARN identifier of the elastic cluster.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The URL used to connect to the elastic cluster.
         */
        public var clusterEndpoint: kotlin.String? = null
        /**
         * The name of the elastic cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The time when the elastic cluster was created in Universal Coordinated Time (UTC).
         */
        public var createTime: kotlin.String? = null
        /**
         * The KMS key identifier to use to encrypt the elastic cluster.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled, as determined by `backupRetentionPeriod`.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *
         * *Format*: `ddd:hh24:mi-ddd:hh24:mi`
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The number of vCPUs assigned to each elastic cluster shard. Maximum is 64. Allowed values are 2, 4, 8, 16, 32, 64.
         */
        public var shardCapacity: kotlin.Int? = null
        /**
         * The number of shards assigned to the elastic cluster. Maximum is 32.
         */
        public var shardCount: kotlin.Int? = null
        /**
         * The number of replica instances applying to all shards in the cluster. A `shardInstanceCount` value of 1 means there is one writer instance, and any additional instances are replicas that can be used for reads and to improve availability.
         */
        public var shardInstanceCount: kotlin.Int? = null
        /**
         * The total number of shards in the cluster.
         */
        public var shards: List<Shard>? = null
        /**
         * The status of the elastic cluster.
         */
        public var status: aws.sdk.kotlin.services.docdbelastic.model.Status? = null
        /**
         * The Amazon EC2 subnet IDs for the elastic cluster.
         */
        public var subnetIds: List<String>? = null
        /**
         * A list of EC2 VPC security groups associated with thie elastic cluster.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.docdbelastic.model.Cluster) : this() {
            this.adminUserName = x.adminUserName
            this.authType = x.authType
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.clusterArn = x.clusterArn
            this.clusterEndpoint = x.clusterEndpoint
            this.clusterName = x.clusterName
            this.createTime = x.createTime
            this.kmsKeyId = x.kmsKeyId
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.shardCapacity = x.shardCapacity
            this.shardCount = x.shardCount
            this.shardInstanceCount = x.shardInstanceCount
            this.shards = x.shards
            this.status = x.status
            this.subnetIds = x.subnetIds
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.docdbelastic.model.Cluster = Cluster(this)

        internal fun correctErrors(): Builder {
            if (adminUserName == null) adminUserName = ""
            if (authType == null) authType = Auth.SdkUnknown("no value provided")
            if (clusterArn == null) clusterArn = ""
            if (clusterEndpoint == null) clusterEndpoint = ""
            if (clusterName == null) clusterName = ""
            if (createTime == null) createTime = ""
            if (kmsKeyId == null) kmsKeyId = ""
            if (preferredMaintenanceWindow == null) preferredMaintenanceWindow = ""
            if (shardCapacity == null) shardCapacity = 0
            if (shardCount == null) shardCount = 0
            if (status == null) status = Status.SdkUnknown("no value provided")
            if (subnetIds == null) subnetIds = emptyList()
            if (vpcSecurityGroupIds == null) vpcSecurityGroupIds = emptyList()
            return this
        }
    }
}
