// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdbelastic

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.docdbelastic.auth.DefaultDocDbElasticAuthSchemeProvider
import aws.sdk.kotlin.services.docdbelastic.auth.DocDbElasticAuthSchemeProvider
import aws.sdk.kotlin.services.docdbelastic.endpoints.DefaultDocDbElasticEndpointProvider
import aws.sdk.kotlin.services.docdbelastic.endpoints.DocDbElasticEndpointParameters
import aws.sdk.kotlin.services.docdbelastic.endpoints.DocDbElasticEndpointProvider
import aws.sdk.kotlin.services.docdbelastic.model.CopyClusterSnapshotRequest
import aws.sdk.kotlin.services.docdbelastic.model.CopyClusterSnapshotResponse
import aws.sdk.kotlin.services.docdbelastic.model.CreateClusterRequest
import aws.sdk.kotlin.services.docdbelastic.model.CreateClusterResponse
import aws.sdk.kotlin.services.docdbelastic.model.CreateClusterSnapshotRequest
import aws.sdk.kotlin.services.docdbelastic.model.CreateClusterSnapshotResponse
import aws.sdk.kotlin.services.docdbelastic.model.DeleteClusterRequest
import aws.sdk.kotlin.services.docdbelastic.model.DeleteClusterResponse
import aws.sdk.kotlin.services.docdbelastic.model.DeleteClusterSnapshotRequest
import aws.sdk.kotlin.services.docdbelastic.model.DeleteClusterSnapshotResponse
import aws.sdk.kotlin.services.docdbelastic.model.GetClusterRequest
import aws.sdk.kotlin.services.docdbelastic.model.GetClusterResponse
import aws.sdk.kotlin.services.docdbelastic.model.GetClusterSnapshotRequest
import aws.sdk.kotlin.services.docdbelastic.model.GetClusterSnapshotResponse
import aws.sdk.kotlin.services.docdbelastic.model.ListClusterSnapshotsRequest
import aws.sdk.kotlin.services.docdbelastic.model.ListClusterSnapshotsResponse
import aws.sdk.kotlin.services.docdbelastic.model.ListClustersRequest
import aws.sdk.kotlin.services.docdbelastic.model.ListClustersResponse
import aws.sdk.kotlin.services.docdbelastic.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.docdbelastic.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.docdbelastic.model.RestoreClusterFromSnapshotRequest
import aws.sdk.kotlin.services.docdbelastic.model.RestoreClusterFromSnapshotResponse
import aws.sdk.kotlin.services.docdbelastic.model.StartClusterRequest
import aws.sdk.kotlin.services.docdbelastic.model.StartClusterResponse
import aws.sdk.kotlin.services.docdbelastic.model.StopClusterRequest
import aws.sdk.kotlin.services.docdbelastic.model.StopClusterResponse
import aws.sdk.kotlin.services.docdbelastic.model.TagResourceRequest
import aws.sdk.kotlin.services.docdbelastic.model.TagResourceResponse
import aws.sdk.kotlin.services.docdbelastic.model.UntagResourceRequest
import aws.sdk.kotlin.services.docdbelastic.model.UntagResourceResponse
import aws.sdk.kotlin.services.docdbelastic.model.UpdateClusterRequest
import aws.sdk.kotlin.services.docdbelastic.model.UpdateClusterResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "DocDB Elastic"
public const val SdkVersion: String = "1.2.40"
public const val ServiceApiVersion: String = "2022-11-28"

/**
 * # Amazon DocumentDB elastic clusters
 * Amazon DocumentDB elastic-clusters support workloads with millions of reads/writes per second and petabytes of storage capacity. Amazon DocumentDB elastic clusters also simplify how developers interact with Amazon DocumentDB elastic-clusters by eliminating the need to choose, manage or upgrade instances.
 *
 * Amazon DocumentDB elastic-clusters were created to:
 * + provide a solution for customers looking for a database that provides virtually limitless scale with rich query capabilities and MongoDB API compatibility.
 * + give customers higher connection limits, and to reduce downtime from patching.
 * + continue investing in a cloud-native, elastic, and class leading architecture for JSON workloads.
 */
public interface DocDbElasticClient : SdkClient {
    /**
     * DocDbElasticClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, DocDbElasticClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "DocDbElastic",
                "DOCDB_ELASTIC",
                "docdb_elastic",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, DocDbElasticClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): DocDbElasticClient = DefaultDocDbElasticClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: DocDbElasticEndpointProvider = builder.endpointProvider ?: DefaultDocDbElasticEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: DocDbElasticAuthSchemeProvider = builder.authSchemeProvider ?: DefaultDocDbElasticAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "DocDB Elastic"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: DocDbElasticEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: DocDbElasticAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Copies a snapshot of an elastic cluster.
     *
     * @sample aws.sdk.kotlin.services.docdbelastic.samples.CopyClusterSnapshot.sample
     */
    public suspend fun copyClusterSnapshot(input: CopyClusterSnapshotRequest): CopyClusterSnapshotResponse

    /**
     * Creates a new Amazon DocumentDB elastic cluster and returns its cluster structure.
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a snapshot of an elastic cluster.
     */
    public suspend fun createClusterSnapshot(input: CreateClusterSnapshotRequest): CreateClusterSnapshotResponse

    /**
     * Delete an elastic cluster.
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Delete an elastic cluster snapshot.
     */
    public suspend fun deleteClusterSnapshot(input: DeleteClusterSnapshotRequest): DeleteClusterSnapshotResponse

    /**
     * Returns information about a specific elastic cluster.
     */
    public suspend fun getCluster(input: GetClusterRequest): GetClusterResponse

    /**
     * Returns information about a specific elastic cluster snapshot
     */
    public suspend fun getClusterSnapshot(input: GetClusterSnapshotRequest): GetClusterSnapshotResponse

    /**
     * Returns information about snapshots for a specified elastic cluster.
     */
    public suspend fun listClusterSnapshots(input: ListClusterSnapshotsRequest = ListClusterSnapshotsRequest { }): ListClusterSnapshotsResponse

    /**
     * Returns information about provisioned Amazon DocumentDB elastic clusters.
     */
    public suspend fun listClusters(input: ListClustersRequest = ListClustersRequest { }): ListClustersResponse

    /**
     * Lists all tags on a elastic cluster resource
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Restores an elastic cluster from a snapshot.
     */
    public suspend fun restoreClusterFromSnapshot(input: RestoreClusterFromSnapshotRequest): RestoreClusterFromSnapshotResponse

    /**
     * Restarts the stopped elastic cluster that is specified by `clusterARN`.
     *
     * @sample aws.sdk.kotlin.services.docdbelastic.samples.StartCluster.sample
     */
    public suspend fun startCluster(input: StartClusterRequest): StartClusterResponse

    /**
     * Stops the running elastic cluster that is specified by `clusterArn`. The elastic cluster must be in the *available* state.
     *
     * @sample aws.sdk.kotlin.services.docdbelastic.samples.StopCluster.sample
     */
    public suspend fun stopCluster(input: StopClusterRequest): StopClusterResponse

    /**
     * Adds metadata tags to an elastic cluster resource
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes metadata tags from an elastic cluster resource
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Modifies an elastic cluster. This includes updating admin-username/password, upgrading the API version, and setting up a backup window and maintenance window
     */
    public suspend fun updateCluster(input: UpdateClusterRequest): UpdateClusterResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun DocDbElasticClient.withConfig(block: DocDbElasticClient.Config.Builder.() -> Unit): DocDbElasticClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultDocDbElasticClient(newConfig)
}

/**
 * Copies a snapshot of an elastic cluster.
 *
 * @sample aws.sdk.kotlin.services.docdbelastic.samples.CopyClusterSnapshot.sample
 */
public suspend inline fun DocDbElasticClient.copyClusterSnapshot(crossinline block: CopyClusterSnapshotRequest.Builder.() -> Unit): CopyClusterSnapshotResponse = copyClusterSnapshot(CopyClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon DocumentDB elastic cluster and returns its cluster structure.
 */
public suspend inline fun DocDbElasticClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of an elastic cluster.
 */
public suspend inline fun DocDbElasticClient.createClusterSnapshot(crossinline block: CreateClusterSnapshotRequest.Builder.() -> Unit): CreateClusterSnapshotResponse = createClusterSnapshot(CreateClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Delete an elastic cluster.
 */
public suspend inline fun DocDbElasticClient.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Delete an elastic cluster snapshot.
 */
public suspend inline fun DocDbElasticClient.deleteClusterSnapshot(crossinline block: DeleteClusterSnapshotRequest.Builder.() -> Unit): DeleteClusterSnapshotResponse = deleteClusterSnapshot(DeleteClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Returns information about a specific elastic cluster.
 */
public suspend inline fun DocDbElasticClient.getCluster(crossinline block: GetClusterRequest.Builder.() -> Unit): GetClusterResponse = getCluster(GetClusterRequest.Builder().apply(block).build())

/**
 * Returns information about a specific elastic cluster snapshot
 */
public suspend inline fun DocDbElasticClient.getClusterSnapshot(crossinline block: GetClusterSnapshotRequest.Builder.() -> Unit): GetClusterSnapshotResponse = getClusterSnapshot(GetClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Returns information about snapshots for a specified elastic cluster.
 */
public suspend inline fun DocDbElasticClient.listClusterSnapshots(crossinline block: ListClusterSnapshotsRequest.Builder.() -> Unit): ListClusterSnapshotsResponse = listClusterSnapshots(ListClusterSnapshotsRequest.Builder().apply(block).build())

/**
 * Returns information about provisioned Amazon DocumentDB elastic clusters.
 */
public suspend inline fun DocDbElasticClient.listClusters(crossinline block: ListClustersRequest.Builder.() -> Unit): ListClustersResponse = listClusters(ListClustersRequest.Builder().apply(block).build())

/**
 * Lists all tags on a elastic cluster resource
 */
public suspend inline fun DocDbElasticClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Restores an elastic cluster from a snapshot.
 */
public suspend inline fun DocDbElasticClient.restoreClusterFromSnapshot(crossinline block: RestoreClusterFromSnapshotRequest.Builder.() -> Unit): RestoreClusterFromSnapshotResponse = restoreClusterFromSnapshot(RestoreClusterFromSnapshotRequest.Builder().apply(block).build())

/**
 * Restarts the stopped elastic cluster that is specified by `clusterARN`.
 *
 * @sample aws.sdk.kotlin.services.docdbelastic.samples.StartCluster.sample
 */
public suspend inline fun DocDbElasticClient.startCluster(crossinline block: StartClusterRequest.Builder.() -> Unit): StartClusterResponse = startCluster(StartClusterRequest.Builder().apply(block).build())

/**
 * Stops the running elastic cluster that is specified by `clusterArn`. The elastic cluster must be in the *available* state.
 *
 * @sample aws.sdk.kotlin.services.docdbelastic.samples.StopCluster.sample
 */
public suspend inline fun DocDbElasticClient.stopCluster(crossinline block: StopClusterRequest.Builder.() -> Unit): StopClusterResponse = stopCluster(StopClusterRequest.Builder().apply(block).build())

/**
 * Adds metadata tags to an elastic cluster resource
 */
public suspend inline fun DocDbElasticClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes metadata tags from an elastic cluster resource
 */
public suspend inline fun DocDbElasticClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Modifies an elastic cluster. This includes updating admin-username/password, upgrading the API version, and setting up a backup window and maintenance window
 */
public suspend inline fun DocDbElasticClient.updateCluster(crossinline block: UpdateClusterRequest.Builder.() -> Unit): UpdateClusterResponse = updateCluster(UpdateClusterRequest.Builder().apply(block).build())
