// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.docdb.model.CreateDbClusterResponse
import aws.sdk.kotlin.services.docdb.model.DocDbException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateDBClusterOperationDeserializer: HttpDeserialize<CreateDbClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateDbClusterResponse {
        if (!response.status.isSuccess()) {
            throwCreateDbClusterError(context, response)
        }
        val builder = CreateDbClusterResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDBClusterOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeCreateDBClusterOperationBody(builder: CreateDbClusterResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)

    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateDBClusterResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateDBClusterResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateDBCluster response")
    }

    val DBCLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DBCluster"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("CreateDBClusterResult"))
        field(DBCLUSTER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBCLUSTER_DESCRIPTOR.index -> builder.dbCluster = deserializeDbClusterDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateDbClusterError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsQuery error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "DBClusterAlreadyExistsFault" -> DbClusterAlreadyExistsFaultDeserializer()
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer()
        "DBClusterParameterGroupNotFound" -> DbClusterParameterGroupNotFoundFaultDeserializer()
        "DBClusterQuotaExceededFault" -> DbClusterQuotaExceededFaultDeserializer()
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer()
        "DBSubnetGroupDoesNotCoverEnoughAZs" -> DbSubnetGroupDoesNotCoverEnoughAZsDeserializer()
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer()
        "GlobalClusterNotFoundFault" -> GlobalClusterNotFoundFaultDeserializer()
        "InsufficientStorageClusterCapacity" -> InsufficientStorageClusterCapacityFaultDeserializer()
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer()
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer()
        "InvalidDBSubnetGroupStateFault" -> InvalidDbSubnetGroupStateFaultDeserializer()
        "InvalidGlobalClusterStateFault" -> InvalidGlobalClusterStateFaultDeserializer()
        "InvalidSubnet" -> InvalidSubnetDeserializer()
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer()
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer()
        "StorageQuotaExceeded" -> StorageQuotaExceededFaultDeserializer()
        else -> throw DocDbException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
