// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * The version of the database engine that an instance can be upgraded to.
 */
class UpgradeTarget private constructor(builder: BuilderImpl) {
    /**
     * A value that indicates whether the target version is applied to any source DB instances that have AutoMinorVersionUpgrade set to true.
     */
    val autoUpgrade: Boolean = builder.autoUpgrade
    /**
     * The version of the database engine that an instance can be upgraded to.
     */
    val description: String? = builder.description
    /**
     * The name of the upgrade target database engine.
     */
    val engine: String? = builder.engine
    /**
     * The version number of the upgrade target database engine.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * A value that indicates whether a database engine is upgraded to a major
     * version.
     */
    val isMajorVersionUpgrade: Boolean = builder.isMajorVersionUpgrade

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpgradeTarget = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpgradeTarget(")
        append("autoUpgrade=$autoUpgrade,")
        append("description=$description,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("isMajorVersionUpgrade=$isMajorVersionUpgrade)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoUpgrade.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (isMajorVersionUpgrade.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpgradeTarget

        if (autoUpgrade != other.autoUpgrade) return false
        if (description != other.description) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (isMajorVersionUpgrade != other.isMajorVersionUpgrade) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpgradeTarget = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpgradeTarget
        /**
         * A value that indicates whether the target version is applied to any source DB instances that have AutoMinorVersionUpgrade set to true.
         */
        fun autoUpgrade(autoUpgrade: Boolean): FluentBuilder
        /**
         * The version of the database engine that an instance can be upgraded to.
         */
        fun description(description: String): FluentBuilder
        /**
         * The name of the upgrade target database engine.
         */
        fun engine(engine: String): FluentBuilder
        /**
         * The version number of the upgrade target database engine.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * A value that indicates whether a database engine is upgraded to a major
         * version.
         */
        fun isMajorVersionUpgrade(isMajorVersionUpgrade: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A value that indicates whether the target version is applied to any source DB instances that have AutoMinorVersionUpgrade set to true.
         */
        var autoUpgrade: Boolean
        /**
         * The version of the database engine that an instance can be upgraded to.
         */
        var description: String?
        /**
         * The name of the upgrade target database engine.
         */
        var engine: String?
        /**
         * The version number of the upgrade target database engine.
         */
        var engineVersion: String?
        /**
         * A value that indicates whether a database engine is upgraded to a major
         * version.
         */
        var isMajorVersionUpgrade: Boolean

        fun build(): UpgradeTarget
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var autoUpgrade: Boolean = false
        override var description: String? = null
        override var engine: String? = null
        override var engineVersion: String? = null
        override var isMajorVersionUpgrade: Boolean = false

        constructor(x: UpgradeTarget) : this() {
            this.autoUpgrade = x.autoUpgrade
            this.description = x.description
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.isMajorVersionUpgrade = x.isMajorVersionUpgrade
        }

        override fun build(): UpgradeTarget = UpgradeTarget(this)
        override fun autoUpgrade(autoUpgrade: Boolean): FluentBuilder = apply { this.autoUpgrade = autoUpgrade }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun isMajorVersionUpgrade(isMajorVersionUpgrade: Boolean): FluentBuilder = apply { this.isMajorVersionUpgrade = isMajorVersionUpgrade }
    }
}
