// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the input to RestoreDBClusterToPointInTime.
 */
class RestoreDbClusterToPointInTimeRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the new cluster to be created.
     * Constraints:
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * The first character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * The subnet group name to use for the new cluster.
     * Constraints: If provided, must match the name of an existing
     * DBSubnetGroup.
     * Example: mySubnetgroup
     */
    val dbSubnetGroupName: String? = builder.dbSubnetGroupName
    /**
     * Specifies whether this cluster can be deleted. If DeletionProtection is enabled, the cluster cannot be deleted unless it is modified and DeletionProtection is disabled. DeletionProtection protects clusters from being accidentally deleted.
     */
    val deletionProtection: Boolean? = builder.deletionProtection
    /**
     * A list of log types that must be enabled for exporting to Amazon CloudWatch
     * Logs.
     */
    val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     * You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the KmsKeyId parameter.
     * If you do not specify a value for the KmsKeyId parameter, then the following occurs:
     * If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.
     * If the cluster is not encrypted, then the restored cluster is not encrypted.
     * If DBClusterIdentifier refers to a cluster that is not encrypted, then
     * the restore request is rejected.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The port number on which the new cluster accepts connections.
     * Constraints: Must be a value from 1150 to 65535.
     * Default: The default port for the engine.
     */
    val port: Int? = builder.port
    /**
     * The date and time to restore the cluster to.
     * Valid values: A time in Universal Coordinated Time (UTC) format.
     * Constraints:
     * Must be before the latest restorable time for the instance.
     * Must be specified if the UseLatestRestorableTime parameter is not provided.
     * Cannot be specified if the UseLatestRestorableTime parameter is true.
     * Cannot be specified if the RestoreType parameter is copy-on-write.
     * Example: 2015-03-07T23:45:00Z
     */
    val restoreToTime: Instant? = builder.restoreToTime
    /**
     * The identifier of the source cluster from which to restore.
     * Constraints:
     * Must match the identifier of an existing DBCluster.
     */
    val sourceDbClusterIdentifier: String? = builder.sourceDbClusterIdentifier
    /**
     * The tags to be assigned to the restored cluster.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A value that is set to true to restore the cluster to the latest
     * restorable backup time, and false otherwise.
     * Default: false
     * Constraints: Cannot be specified if the RestoreToTime parameter is
     * provided.
     */
    val useLatestRestorableTime: Boolean = builder.useLatestRestorableTime
    /**
     * A list of VPC security groups that the new cluster belongs to.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RestoreDbClusterToPointInTimeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbClusterToPointInTimeRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("kmsKeyId=$kmsKeyId,")
        append("port=$port,")
        append("restoreToTime=$restoreToTime,")
        append("sourceDbClusterIdentifier=$sourceDbClusterIdentifier,")
        append("tags=$tags,")
        append("useLatestRestorableTime=$useLatestRestorableTime,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (restoreToTime?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useLatestRestorableTime.hashCode())
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RestoreDbClusterToPointInTimeRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (port != other.port) return false
        if (restoreToTime != other.restoreToTime) return false
        if (sourceDbClusterIdentifier != other.sourceDbClusterIdentifier) return false
        if (tags != other.tags) return false
        if (useLatestRestorableTime != other.useLatestRestorableTime) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RestoreDbClusterToPointInTimeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RestoreDbClusterToPointInTimeRequest
        /**
         * The name of the new cluster to be created.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * The subnet group name to use for the new cluster.
         * Constraints: If provided, must match the name of an existing
         * DBSubnetGroup.
         * Example: mySubnetgroup
         */
        fun dbSubnetGroupName(dbSubnetGroupName: String): FluentBuilder
        /**
         * Specifies whether this cluster can be deleted. If DeletionProtection is enabled, the cluster cannot be deleted unless it is modified and DeletionProtection is disabled. DeletionProtection protects clusters from being accidentally deleted.
         */
        fun deletionProtection(deletionProtection: Boolean): FluentBuilder
        /**
         * A list of log types that must be enabled for exporting to Amazon CloudWatch
         * Logs.
         */
        fun enableCloudwatchLogsExports(enableCloudwatchLogsExports: List<String>): FluentBuilder
        /**
         * The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         * You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the KmsKeyId parameter.
         * If you do not specify a value for the KmsKeyId parameter, then the following occurs:
         * If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.
         * If the cluster is not encrypted, then the restored cluster is not encrypted.
         * If DBClusterIdentifier refers to a cluster that is not encrypted, then
         * the restore request is rejected.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The port number on which the new cluster accepts connections.
         * Constraints: Must be a value from 1150 to 65535.
         * Default: The default port for the engine.
         */
        fun port(port: Int): FluentBuilder
        /**
         * The date and time to restore the cluster to.
         * Valid values: A time in Universal Coordinated Time (UTC) format.
         * Constraints:
         * Must be before the latest restorable time for the instance.
         * Must be specified if the UseLatestRestorableTime parameter is not provided.
         * Cannot be specified if the UseLatestRestorableTime parameter is true.
         * Cannot be specified if the RestoreType parameter is copy-on-write.
         * Example: 2015-03-07T23:45:00Z
         */
        fun restoreToTime(restoreToTime: Instant): FluentBuilder
        /**
         * The identifier of the source cluster from which to restore.
         * Constraints:
         * Must match the identifier of an existing DBCluster.
         */
        fun sourceDbClusterIdentifier(sourceDbClusterIdentifier: String): FluentBuilder
        /**
         * The tags to be assigned to the restored cluster.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * A value that is set to true to restore the cluster to the latest
         * restorable backup time, and false otherwise.
         * Default: false
         * Constraints: Cannot be specified if the RestoreToTime parameter is
         * provided.
         */
        fun useLatestRestorableTime(useLatestRestorableTime: Boolean): FluentBuilder
        /**
         * A list of VPC security groups that the new cluster belongs to.
         */
        fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the new cluster to be created.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        var dbClusterIdentifier: String?
        /**
         * The subnet group name to use for the new cluster.
         * Constraints: If provided, must match the name of an existing
         * DBSubnetGroup.
         * Example: mySubnetgroup
         */
        var dbSubnetGroupName: String?
        /**
         * Specifies whether this cluster can be deleted. If DeletionProtection is enabled, the cluster cannot be deleted unless it is modified and DeletionProtection is disabled. DeletionProtection protects clusters from being accidentally deleted.
         */
        var deletionProtection: Boolean?
        /**
         * A list of log types that must be enabled for exporting to Amazon CloudWatch
         * Logs.
         */
        var enableCloudwatchLogsExports: List<String>?
        /**
         * The KMS key identifier to use when restoring an encrypted cluster from an encrypted cluster.
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a cluster with the same account that owns the KMS encryption key used to encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         * You can restore to a new cluster and encrypt the new cluster with an KMS key that is different from the KMS key used to encrypt the source cluster. The new DB cluster is encrypted with the KMS key identified by the KmsKeyId parameter.
         * If you do not specify a value for the KmsKeyId parameter, then the following occurs:
         * If the cluster is encrypted, then the restored cluster is encrypted using the KMS key that was used to encrypt the source cluster.
         * If the cluster is not encrypted, then the restored cluster is not encrypted.
         * If DBClusterIdentifier refers to a cluster that is not encrypted, then
         * the restore request is rejected.
         */
        var kmsKeyId: String?
        /**
         * The port number on which the new cluster accepts connections.
         * Constraints: Must be a value from 1150 to 65535.
         * Default: The default port for the engine.
         */
        var port: Int?
        /**
         * The date and time to restore the cluster to.
         * Valid values: A time in Universal Coordinated Time (UTC) format.
         * Constraints:
         * Must be before the latest restorable time for the instance.
         * Must be specified if the UseLatestRestorableTime parameter is not provided.
         * Cannot be specified if the UseLatestRestorableTime parameter is true.
         * Cannot be specified if the RestoreType parameter is copy-on-write.
         * Example: 2015-03-07T23:45:00Z
         */
        var restoreToTime: Instant?
        /**
         * The identifier of the source cluster from which to restore.
         * Constraints:
         * Must match the identifier of an existing DBCluster.
         */
        var sourceDbClusterIdentifier: String?
        /**
         * The tags to be assigned to the restored cluster.
         */
        var tags: List<Tag>?
        /**
         * A value that is set to true to restore the cluster to the latest
         * restorable backup time, and false otherwise.
         * Default: false
         * Constraints: Cannot be specified if the RestoreToTime parameter is
         * provided.
         */
        var useLatestRestorableTime: Boolean
        /**
         * A list of VPC security groups that the new cluster belongs to.
         */
        var vpcSecurityGroupIds: List<String>?

        fun build(): RestoreDbClusterToPointInTimeRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbClusterIdentifier: String? = null
        override var dbSubnetGroupName: String? = null
        override var deletionProtection: Boolean? = null
        override var enableCloudwatchLogsExports: List<String>? = null
        override var kmsKeyId: String? = null
        override var port: Int? = null
        override var restoreToTime: Instant? = null
        override var sourceDbClusterIdentifier: String? = null
        override var tags: List<Tag>? = null
        override var useLatestRestorableTime: Boolean = false
        override var vpcSecurityGroupIds: List<String>? = null

        constructor(x: RestoreDbClusterToPointInTimeRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.kmsKeyId = x.kmsKeyId
            this.port = x.port
            this.restoreToTime = x.restoreToTime
            this.sourceDbClusterIdentifier = x.sourceDbClusterIdentifier
            this.tags = x.tags
            this.useLatestRestorableTime = x.useLatestRestorableTime
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        override fun build(): RestoreDbClusterToPointInTimeRequest = RestoreDbClusterToPointInTimeRequest(this)
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun dbSubnetGroupName(dbSubnetGroupName: String): FluentBuilder = apply { this.dbSubnetGroupName = dbSubnetGroupName }
        override fun deletionProtection(deletionProtection: Boolean): FluentBuilder = apply { this.deletionProtection = deletionProtection }
        override fun enableCloudwatchLogsExports(enableCloudwatchLogsExports: List<String>): FluentBuilder = apply { this.enableCloudwatchLogsExports = enableCloudwatchLogsExports }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun restoreToTime(restoreToTime: Instant): FluentBuilder = apply { this.restoreToTime = restoreToTime }
        override fun sourceDbClusterIdentifier(sourceDbClusterIdentifier: String): FluentBuilder = apply { this.sourceDbClusterIdentifier = sourceDbClusterIdentifier }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun useLatestRestorableTime(useLatestRestorableTime: Boolean): FluentBuilder = apply { this.useLatestRestorableTime = useLatestRestorableTime }
        override fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder = apply { this.vpcSecurityGroupIds = vpcSecurityGroupIds }
    }
}
