// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to ResetDBClusterParameterGroup.
 */
class ResetDbClusterParameterGroupRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the cluster parameter group to reset.
     */
    val dbClusterParameterGroupName: String? = builder.dbClusterParameterGroupName
    /**
     * A list of parameter names in the cluster parameter group to reset to the default
     * values. You can't use this parameter if the ResetAllParameters parameter is
     * set to true.
     */
    val parameters: List<Parameter>? = builder.parameters
    /**
     * A value that is set to true to reset all parameters in the cluster
     * parameter group to their default values, and false otherwise. You can't use
     * this parameter if there is a list of parameter names specified for the
     * Parameters parameter.
     */
    val resetAllParameters: Boolean = builder.resetAllParameters

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ResetDbClusterParameterGroupRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ResetDbClusterParameterGroupRequest(")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("parameters=$parameters,")
        append("resetAllParameters=$resetAllParameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterParameterGroupName?.hashCode() ?: 0
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (resetAllParameters.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ResetDbClusterParameterGroupRequest

        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (parameters != other.parameters) return false
        if (resetAllParameters != other.resetAllParameters) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ResetDbClusterParameterGroupRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ResetDbClusterParameterGroupRequest
        /**
         * The name of the cluster parameter group to reset.
         */
        fun dbClusterParameterGroupName(dbClusterParameterGroupName: String): FluentBuilder
        /**
         * A list of parameter names in the cluster parameter group to reset to the default
         * values. You can't use this parameter if the ResetAllParameters parameter is
         * set to true.
         */
        fun parameters(parameters: List<Parameter>): FluentBuilder
        /**
         * A value that is set to true to reset all parameters in the cluster
         * parameter group to their default values, and false otherwise. You can't use
         * this parameter if there is a list of parameter names specified for the
         * Parameters parameter.
         */
        fun resetAllParameters(resetAllParameters: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the cluster parameter group to reset.
         */
        var dbClusterParameterGroupName: String?
        /**
         * A list of parameter names in the cluster parameter group to reset to the default
         * values. You can't use this parameter if the ResetAllParameters parameter is
         * set to true.
         */
        var parameters: List<Parameter>?
        /**
         * A value that is set to true to reset all parameters in the cluster
         * parameter group to their default values, and false otherwise. You can't use
         * this parameter if there is a list of parameter names specified for the
         * Parameters parameter.
         */
        var resetAllParameters: Boolean

        fun build(): ResetDbClusterParameterGroupRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbClusterParameterGroupName: String? = null
        override var parameters: List<Parameter>? = null
        override var resetAllParameters: Boolean = false

        constructor(x: ResetDbClusterParameterGroupRequest) : this() {
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.parameters = x.parameters
            this.resetAllParameters = x.resetAllParameters
        }

        override fun build(): ResetDbClusterParameterGroupRequest = ResetDbClusterParameterGroupRequest(this)
        override fun dbClusterParameterGroupName(dbClusterParameterGroupName: String): FluentBuilder = apply { this.dbClusterParameterGroupName = dbClusterParameterGroupName }
        override fun parameters(parameters: List<Parameter>): FluentBuilder = apply { this.parameters = parameters }
        override fun resetAllParameters(resetAllParameters: Boolean): FluentBuilder = apply { this.resetAllParameters = resetAllParameters }
    }
}
