// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to RebootDBInstance.
 */
class RebootDbInstanceRequest private constructor(builder: BuilderImpl) {
    /**
     * The instance identifier. This parameter is stored as a lowercase string.
     * Constraints:
     * Must match the identifier of an existing DBInstance.
     */
    val dbInstanceIdentifier: String? = builder.dbInstanceIdentifier
    /**
     * When true, the reboot is conducted through a Multi-AZ failover.
     * Constraint: You can't specify true if the instance is not configured for
     * Multi-AZ.
     */
    val forceFailover: Boolean? = builder.forceFailover

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RebootDbInstanceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RebootDbInstanceRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("forceFailover=$forceFailover)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (forceFailover?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RebootDbInstanceRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (forceFailover != other.forceFailover) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RebootDbInstanceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RebootDbInstanceRequest
        /**
         * The instance identifier. This parameter is stored as a lowercase string.
         * Constraints:
         * Must match the identifier of an existing DBInstance.
         */
        fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder
        /**
         * When true, the reboot is conducted through a Multi-AZ failover.
         * Constraint: You can't specify true if the instance is not configured for
         * Multi-AZ.
         */
        fun forceFailover(forceFailover: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The instance identifier. This parameter is stored as a lowercase string.
         * Constraints:
         * Must match the identifier of an existing DBInstance.
         */
        var dbInstanceIdentifier: String?
        /**
         * When true, the reboot is conducted through a Multi-AZ failover.
         * Constraint: You can't specify true if the instance is not configured for
         * Multi-AZ.
         */
        var forceFailover: Boolean?

        fun build(): RebootDbInstanceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbInstanceIdentifier: String? = null
        override var forceFailover: Boolean? = null

        constructor(x: RebootDbInstanceRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.forceFailover = x.forceFailover
        }

        override fun build(): RebootDbInstanceRequest = RebootDbInstanceRequest(this)
        override fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder = apply { this.dbInstanceIdentifier = dbInstanceIdentifier }
        override fun forceFailover(forceFailover: Boolean): FluentBuilder = apply { this.forceFailover = forceFailover }
    }
}
