// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * One or more modified settings for an instance. These modified settings have been
 * requested, but haven't been applied yet.
 */
class PendingModifiedValues private constructor(builder: BuilderImpl) {
    /**
     * Contains the new AllocatedStorage size for then instance that will be
     * applied or is currently being applied.
     */
    val allocatedStorage: Int? = builder.allocatedStorage
    /**
     * Specifies the pending number of days for which automated backups are retained.
     */
    val backupRetentionPeriod: Int? = builder.backupRetentionPeriod
    /**
     * Specifies the identifier of the certificate authority (CA) certificate for the DB
     * instance.
     */
    val caCertificateIdentifier: String? = builder.caCertificateIdentifier
    /**
     * Contains the new DBInstanceClass for the instance that will be
     * applied or is currently being applied.
     */
    val dbInstanceClass: String? = builder.dbInstanceClass
    /**
     * Contains the new DBInstanceIdentifier for the instance that will be
     * applied or is currently being applied.
     */
    val dbInstanceIdentifier: String? = builder.dbInstanceIdentifier
    /**
     * The new subnet group for the instance.
     */
    val dbSubnetGroupName: String? = builder.dbSubnetGroupName
    /**
     * Indicates the database engine version.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * Specifies the new Provisioned IOPS value for the instance that will be applied or
     * is currently being applied.
     */
    val iops: Int? = builder.iops
    /**
     * The license model for the instance.
     * Valid values: license-included, bring-your-own-license,
     * general-public-license
     */
    val licenseModel: String? = builder.licenseModel
    /**
     * Contains the pending or currently in-progress change of the master credentials for the
     * instance.
     */
    val masterUserPassword: String? = builder.masterUserPassword
    /**
     * Indicates that the Single-AZ instance is to change to a Multi-AZ deployment.
     */
    val multiAz: Boolean? = builder.multiAz
    /**
     * A list of the log types whose configuration is still pending. These log types are in
     * the process of being activated or deactivated.
     */
    val pendingCloudwatchLogsExports: PendingCloudwatchLogsExports? = builder.pendingCloudwatchLogsExports
    /**
     * Specifies the pending port for the instance.
     */
    val port: Int? = builder.port
    /**
     * Specifies the storage type to be associated with the instance.
     */
    val storageType: String? = builder.storageType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PendingModifiedValues = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PendingModifiedValues(")
        append("allocatedStorage=$allocatedStorage,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("engineVersion=$engineVersion,")
        append("iops=$iops,")
        append("licenseModel=$licenseModel,")
        append("masterUserPassword=$masterUserPassword,")
        append("multiAz=$multiAz,")
        append("pendingCloudwatchLogsExports=$pendingCloudwatchLogsExports,")
        append("port=$port,")
        append("storageType=$storageType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (pendingCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PendingModifiedValues

        if (allocatedStorage != other.allocatedStorage) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (engineVersion != other.engineVersion) return false
        if (iops != other.iops) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (multiAz != other.multiAz) return false
        if (pendingCloudwatchLogsExports != other.pendingCloudwatchLogsExports) return false
        if (port != other.port) return false
        if (storageType != other.storageType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PendingModifiedValues = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PendingModifiedValues
        /**
         * Contains the new AllocatedStorage size for then instance that will be
         * applied or is currently being applied.
         */
        fun allocatedStorage(allocatedStorage: Int): FluentBuilder
        /**
         * Specifies the pending number of days for which automated backups are retained.
         */
        fun backupRetentionPeriod(backupRetentionPeriod: Int): FluentBuilder
        /**
         * Specifies the identifier of the certificate authority (CA) certificate for the DB
         * instance.
         */
        fun caCertificateIdentifier(caCertificateIdentifier: String): FluentBuilder
        /**
         * Contains the new DBInstanceClass for the instance that will be
         * applied or is currently being applied.
         */
        fun dbInstanceClass(dbInstanceClass: String): FluentBuilder
        /**
         * Contains the new DBInstanceIdentifier for the instance that will be
         * applied or is currently being applied.
         */
        fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder
        /**
         * The new subnet group for the instance.
         */
        fun dbSubnetGroupName(dbSubnetGroupName: String): FluentBuilder
        /**
         * Indicates the database engine version.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * Specifies the new Provisioned IOPS value for the instance that will be applied or
         * is currently being applied.
         */
        fun iops(iops: Int): FluentBuilder
        /**
         * The license model for the instance.
         * Valid values: license-included, bring-your-own-license,
         * general-public-license
         */
        fun licenseModel(licenseModel: String): FluentBuilder
        /**
         * Contains the pending or currently in-progress change of the master credentials for the
         * instance.
         */
        fun masterUserPassword(masterUserPassword: String): FluentBuilder
        /**
         * Indicates that the Single-AZ instance is to change to a Multi-AZ deployment.
         */
        fun multiAz(multiAz: Boolean): FluentBuilder
        /**
         * A list of the log types whose configuration is still pending. These log types are in
         * the process of being activated or deactivated.
         */
        fun pendingCloudwatchLogsExports(pendingCloudwatchLogsExports: PendingCloudwatchLogsExports): FluentBuilder
        /**
         * Specifies the pending port for the instance.
         */
        fun port(port: Int): FluentBuilder
        /**
         * Specifies the storage type to be associated with the instance.
         */
        fun storageType(storageType: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains the new AllocatedStorage size for then instance that will be
         * applied or is currently being applied.
         */
        var allocatedStorage: Int?
        /**
         * Specifies the pending number of days for which automated backups are retained.
         */
        var backupRetentionPeriod: Int?
        /**
         * Specifies the identifier of the certificate authority (CA) certificate for the DB
         * instance.
         */
        var caCertificateIdentifier: String?
        /**
         * Contains the new DBInstanceClass for the instance that will be
         * applied or is currently being applied.
         */
        var dbInstanceClass: String?
        /**
         * Contains the new DBInstanceIdentifier for the instance that will be
         * applied or is currently being applied.
         */
        var dbInstanceIdentifier: String?
        /**
         * The new subnet group for the instance.
         */
        var dbSubnetGroupName: String?
        /**
         * Indicates the database engine version.
         */
        var engineVersion: String?
        /**
         * Specifies the new Provisioned IOPS value for the instance that will be applied or
         * is currently being applied.
         */
        var iops: Int?
        /**
         * The license model for the instance.
         * Valid values: license-included, bring-your-own-license,
         * general-public-license
         */
        var licenseModel: String?
        /**
         * Contains the pending or currently in-progress change of the master credentials for the
         * instance.
         */
        var masterUserPassword: String?
        /**
         * Indicates that the Single-AZ instance is to change to a Multi-AZ deployment.
         */
        var multiAz: Boolean?
        /**
         * A list of the log types whose configuration is still pending. These log types are in
         * the process of being activated or deactivated.
         */
        var pendingCloudwatchLogsExports: PendingCloudwatchLogsExports?
        /**
         * Specifies the pending port for the instance.
         */
        var port: Int?
        /**
         * Specifies the storage type to be associated with the instance.
         */
        var storageType: String?

        fun build(): PendingModifiedValues
        /**
         * construct an [aws.sdk.kotlin.services.docdb.model.PendingCloudwatchLogsExports] inside the given [block]
         */
        fun pendingCloudwatchLogsExports(block: PendingCloudwatchLogsExports.DslBuilder.() -> kotlin.Unit) {
            this.pendingCloudwatchLogsExports = PendingCloudwatchLogsExports.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allocatedStorage: Int? = null
        override var backupRetentionPeriod: Int? = null
        override var caCertificateIdentifier: String? = null
        override var dbInstanceClass: String? = null
        override var dbInstanceIdentifier: String? = null
        override var dbSubnetGroupName: String? = null
        override var engineVersion: String? = null
        override var iops: Int? = null
        override var licenseModel: String? = null
        override var masterUserPassword: String? = null
        override var multiAz: Boolean? = null
        override var pendingCloudwatchLogsExports: PendingCloudwatchLogsExports? = null
        override var port: Int? = null
        override var storageType: String? = null

        constructor(x: PendingModifiedValues) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.engineVersion = x.engineVersion
            this.iops = x.iops
            this.licenseModel = x.licenseModel
            this.masterUserPassword = x.masterUserPassword
            this.multiAz = x.multiAz
            this.pendingCloudwatchLogsExports = x.pendingCloudwatchLogsExports
            this.port = x.port
            this.storageType = x.storageType
        }

        override fun build(): PendingModifiedValues = PendingModifiedValues(this)
        override fun allocatedStorage(allocatedStorage: Int): FluentBuilder = apply { this.allocatedStorage = allocatedStorage }
        override fun backupRetentionPeriod(backupRetentionPeriod: Int): FluentBuilder = apply { this.backupRetentionPeriod = backupRetentionPeriod }
        override fun caCertificateIdentifier(caCertificateIdentifier: String): FluentBuilder = apply { this.caCertificateIdentifier = caCertificateIdentifier }
        override fun dbInstanceClass(dbInstanceClass: String): FluentBuilder = apply { this.dbInstanceClass = dbInstanceClass }
        override fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder = apply { this.dbInstanceIdentifier = dbInstanceIdentifier }
        override fun dbSubnetGroupName(dbSubnetGroupName: String): FluentBuilder = apply { this.dbSubnetGroupName = dbSubnetGroupName }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun iops(iops: Int): FluentBuilder = apply { this.iops = iops }
        override fun licenseModel(licenseModel: String): FluentBuilder = apply { this.licenseModel = licenseModel }
        override fun masterUserPassword(masterUserPassword: String): FluentBuilder = apply { this.masterUserPassword = masterUserPassword }
        override fun multiAz(multiAz: Boolean): FluentBuilder = apply { this.multiAz = multiAz }
        override fun pendingCloudwatchLogsExports(pendingCloudwatchLogsExports: PendingCloudwatchLogsExports): FluentBuilder = apply { this.pendingCloudwatchLogsExports = pendingCloudwatchLogsExports }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun storageType(storageType: String): FluentBuilder = apply { this.storageType = storageType }
    }
}
