// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a pending maintenance action for a resource.
 */
class PendingMaintenanceAction private constructor(builder: BuilderImpl) {
    /**
     * The type of pending maintenance action that is available for the resource.
     */
    val action: String? = builder.action
    /**
     * The date of the maintenance window when the action is applied. The maintenance action
     * is applied to the resource during its first maintenance window after this date. If this
     * date is specified, any next-maintenance opt-in requests are ignored.
     */
    val autoAppliedAfterDate: Instant? = builder.autoAppliedAfterDate
    /**
     * The effective date when the pending maintenance action is applied to the
     * resource.
     */
    val currentApplyDate: Instant? = builder.currentApplyDate
    /**
     * A description providing more detail about the maintenance action.
     */
    val description: String? = builder.description
    /**
     * The date when the maintenance action is automatically applied. The maintenance action
     * is applied to the resource on this date regardless of the maintenance window for the
     * resource. If this date is specified, any immediate opt-in requests are
     * ignored.
     */
    val forcedApplyDate: Instant? = builder.forcedApplyDate
    /**
     * Indicates the type of opt-in request that has been received for the resource.
     */
    val optInStatus: String? = builder.optInStatus

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PendingMaintenanceAction = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PendingMaintenanceAction(")
        append("action=$action,")
        append("autoAppliedAfterDate=$autoAppliedAfterDate,")
        append("currentApplyDate=$currentApplyDate,")
        append("description=$description,")
        append("forcedApplyDate=$forcedApplyDate,")
        append("optInStatus=$optInStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (autoAppliedAfterDate?.hashCode() ?: 0)
        result = 31 * result + (currentApplyDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (forcedApplyDate?.hashCode() ?: 0)
        result = 31 * result + (optInStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PendingMaintenanceAction

        if (action != other.action) return false
        if (autoAppliedAfterDate != other.autoAppliedAfterDate) return false
        if (currentApplyDate != other.currentApplyDate) return false
        if (description != other.description) return false
        if (forcedApplyDate != other.forcedApplyDate) return false
        if (optInStatus != other.optInStatus) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PendingMaintenanceAction = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PendingMaintenanceAction
        /**
         * The type of pending maintenance action that is available for the resource.
         */
        fun action(action: String): FluentBuilder
        /**
         * The date of the maintenance window when the action is applied. The maintenance action
         * is applied to the resource during its first maintenance window after this date. If this
         * date is specified, any next-maintenance opt-in requests are ignored.
         */
        fun autoAppliedAfterDate(autoAppliedAfterDate: Instant): FluentBuilder
        /**
         * The effective date when the pending maintenance action is applied to the
         * resource.
         */
        fun currentApplyDate(currentApplyDate: Instant): FluentBuilder
        /**
         * A description providing more detail about the maintenance action.
         */
        fun description(description: String): FluentBuilder
        /**
         * The date when the maintenance action is automatically applied. The maintenance action
         * is applied to the resource on this date regardless of the maintenance window for the
         * resource. If this date is specified, any immediate opt-in requests are
         * ignored.
         */
        fun forcedApplyDate(forcedApplyDate: Instant): FluentBuilder
        /**
         * Indicates the type of opt-in request that has been received for the resource.
         */
        fun optInStatus(optInStatus: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The type of pending maintenance action that is available for the resource.
         */
        var action: String?
        /**
         * The date of the maintenance window when the action is applied. The maintenance action
         * is applied to the resource during its first maintenance window after this date. If this
         * date is specified, any next-maintenance opt-in requests are ignored.
         */
        var autoAppliedAfterDate: Instant?
        /**
         * The effective date when the pending maintenance action is applied to the
         * resource.
         */
        var currentApplyDate: Instant?
        /**
         * A description providing more detail about the maintenance action.
         */
        var description: String?
        /**
         * The date when the maintenance action is automatically applied. The maintenance action
         * is applied to the resource on this date regardless of the maintenance window for the
         * resource. If this date is specified, any immediate opt-in requests are
         * ignored.
         */
        var forcedApplyDate: Instant?
        /**
         * Indicates the type of opt-in request that has been received for the resource.
         */
        var optInStatus: String?

        fun build(): PendingMaintenanceAction
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var action: String? = null
        override var autoAppliedAfterDate: Instant? = null
        override var currentApplyDate: Instant? = null
        override var description: String? = null
        override var forcedApplyDate: Instant? = null
        override var optInStatus: String? = null

        constructor(x: PendingMaintenanceAction) : this() {
            this.action = x.action
            this.autoAppliedAfterDate = x.autoAppliedAfterDate
            this.currentApplyDate = x.currentApplyDate
            this.description = x.description
            this.forcedApplyDate = x.forcedApplyDate
            this.optInStatus = x.optInStatus
        }

        override fun build(): PendingMaintenanceAction = PendingMaintenanceAction(this)
        override fun action(action: String): FluentBuilder = apply { this.action = action }
        override fun autoAppliedAfterDate(autoAppliedAfterDate: Instant): FluentBuilder = apply { this.autoAppliedAfterDate = autoAppliedAfterDate }
        override fun currentApplyDate(currentApplyDate: Instant): FluentBuilder = apply { this.currentApplyDate = currentApplyDate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun forcedApplyDate(forcedApplyDate: Instant): FluentBuilder = apply { this.forcedApplyDate = forcedApplyDate }
        override fun optInStatus(optInStatus: String): FluentBuilder = apply { this.optInStatus = optInStatus }
    }
}
