// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Detailed information about an individual parameter.
 */
class Parameter private constructor(builder: BuilderImpl) {
    /**
     * Specifies the valid range of values for the parameter.
     */
    val allowedValues: String? = builder.allowedValues
    /**
     * Indicates when to apply parameter updates.
     */
    val applyMethod: ApplyMethod? = builder.applyMethod
    /**
     * Specifies the engine-specific parameters type.
     */
    val applyType: String? = builder.applyType
    /**
     * Specifies the valid data type for the parameter.
     */
    val dataType: String? = builder.dataType
    /**
     * Provides a description of the parameter.
     */
    val description: String? = builder.description
    /**
     * Indicates whether (true) or not (false) the parameter can
     * be modified. Some parameters have security or operational implications that prevent them
     * from being changed.
     */
    val isModifiable: Boolean = builder.isModifiable
    /**
     * The earliest engine version to which the parameter can apply.
     */
    val minimumEngineVersion: String? = builder.minimumEngineVersion
    /**
     * Specifies the name of the parameter.
     */
    val parameterName: String? = builder.parameterName
    /**
     * Specifies the value of the parameter.
     */
    val parameterValue: String? = builder.parameterValue
    /**
     * Indicates the source of the parameter value.
     */
    val source: String? = builder.source

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Parameter = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Parameter(")
        append("allowedValues=$allowedValues,")
        append("applyMethod=$applyMethod,")
        append("applyType=$applyType,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("isModifiable=$isModifiable,")
        append("minimumEngineVersion=$minimumEngineVersion,")
        append("parameterName=$parameterName,")
        append("parameterValue=$parameterValue,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (applyMethod?.hashCode() ?: 0)
        result = 31 * result + (applyType?.hashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isModifiable.hashCode())
        result = 31 * result + (minimumEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        result = 31 * result + (parameterValue?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Parameter

        if (allowedValues != other.allowedValues) return false
        if (applyMethod != other.applyMethod) return false
        if (applyType != other.applyType) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (isModifiable != other.isModifiable) return false
        if (minimumEngineVersion != other.minimumEngineVersion) return false
        if (parameterName != other.parameterName) return false
        if (parameterValue != other.parameterValue) return false
        if (source != other.source) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Parameter = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Parameter
        /**
         * Specifies the valid range of values for the parameter.
         */
        fun allowedValues(allowedValues: String): FluentBuilder
        /**
         * Indicates when to apply parameter updates.
         */
        fun applyMethod(applyMethod: ApplyMethod): FluentBuilder
        /**
         * Specifies the engine-specific parameters type.
         */
        fun applyType(applyType: String): FluentBuilder
        /**
         * Specifies the valid data type for the parameter.
         */
        fun dataType(dataType: String): FluentBuilder
        /**
         * Provides a description of the parameter.
         */
        fun description(description: String): FluentBuilder
        /**
         * Indicates whether (true) or not (false) the parameter can
         * be modified. Some parameters have security or operational implications that prevent them
         * from being changed.
         */
        fun isModifiable(isModifiable: Boolean): FluentBuilder
        /**
         * The earliest engine version to which the parameter can apply.
         */
        fun minimumEngineVersion(minimumEngineVersion: String): FluentBuilder
        /**
         * Specifies the name of the parameter.
         */
        fun parameterName(parameterName: String): FluentBuilder
        /**
         * Specifies the value of the parameter.
         */
        fun parameterValue(parameterValue: String): FluentBuilder
        /**
         * Indicates the source of the parameter value.
         */
        fun source(source: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies the valid range of values for the parameter.
         */
        var allowedValues: String?
        /**
         * Indicates when to apply parameter updates.
         */
        var applyMethod: ApplyMethod?
        /**
         * Specifies the engine-specific parameters type.
         */
        var applyType: String?
        /**
         * Specifies the valid data type for the parameter.
         */
        var dataType: String?
        /**
         * Provides a description of the parameter.
         */
        var description: String?
        /**
         * Indicates whether (true) or not (false) the parameter can
         * be modified. Some parameters have security or operational implications that prevent them
         * from being changed.
         */
        var isModifiable: Boolean
        /**
         * The earliest engine version to which the parameter can apply.
         */
        var minimumEngineVersion: String?
        /**
         * Specifies the name of the parameter.
         */
        var parameterName: String?
        /**
         * Specifies the value of the parameter.
         */
        var parameterValue: String?
        /**
         * Indicates the source of the parameter value.
         */
        var source: String?

        fun build(): Parameter
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowedValues: String? = null
        override var applyMethod: ApplyMethod? = null
        override var applyType: String? = null
        override var dataType: String? = null
        override var description: String? = null
        override var isModifiable: Boolean = false
        override var minimumEngineVersion: String? = null
        override var parameterName: String? = null
        override var parameterValue: String? = null
        override var source: String? = null

        constructor(x: Parameter) : this() {
            this.allowedValues = x.allowedValues
            this.applyMethod = x.applyMethod
            this.applyType = x.applyType
            this.dataType = x.dataType
            this.description = x.description
            this.isModifiable = x.isModifiable
            this.minimumEngineVersion = x.minimumEngineVersion
            this.parameterName = x.parameterName
            this.parameterValue = x.parameterValue
            this.source = x.source
        }

        override fun build(): Parameter = Parameter(this)
        override fun allowedValues(allowedValues: String): FluentBuilder = apply { this.allowedValues = allowedValues }
        override fun applyMethod(applyMethod: ApplyMethod): FluentBuilder = apply { this.applyMethod = applyMethod }
        override fun applyType(applyType: String): FluentBuilder = apply { this.applyType = applyType }
        override fun dataType(dataType: String): FluentBuilder = apply { this.dataType = dataType }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun isModifiable(isModifiable: Boolean): FluentBuilder = apply { this.isModifiable = isModifiable }
        override fun minimumEngineVersion(minimumEngineVersion: String): FluentBuilder = apply { this.minimumEngineVersion = minimumEngineVersion }
        override fun parameterName(parameterName: String): FluentBuilder = apply { this.parameterName = parameterName }
        override fun parameterValue(parameterValue: String): FluentBuilder = apply { this.parameterValue = parameterValue }
        override fun source(source: String): FluentBuilder = apply { this.source = source }
    }
}
