// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * The options that are available for an instance.
 */
class OrderableDbInstanceOption private constructor(builder: BuilderImpl) {
    /**
     * A list of Availability Zones for an instance.
     */
    val availabilityZones: List<AvailabilityZone>? = builder.availabilityZones
    /**
     * The instance class for an instance.
     */
    val dbInstanceClass: String? = builder.dbInstanceClass
    /**
     * The engine type of an instance.
     */
    val engine: String? = builder.engine
    /**
     * The engine version of an instance.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * The license model for an instance.
     */
    val licenseModel: String? = builder.licenseModel
    /**
     * Indicates whether an instance is in a virtual private cloud (VPC).
     */
    val vpc: Boolean = builder.vpc

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OrderableDbInstanceOption = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OrderableDbInstanceOption(")
        append("availabilityZones=$availabilityZones,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("licenseModel=$licenseModel,")
        append("vpc=$vpc)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (vpc.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OrderableDbInstanceOption

        if (availabilityZones != other.availabilityZones) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (licenseModel != other.licenseModel) return false
        if (vpc != other.vpc) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OrderableDbInstanceOption = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OrderableDbInstanceOption
        /**
         * A list of Availability Zones for an instance.
         */
        fun availabilityZones(availabilityZones: List<AvailabilityZone>): FluentBuilder
        /**
         * The instance class for an instance.
         */
        fun dbInstanceClass(dbInstanceClass: String): FluentBuilder
        /**
         * The engine type of an instance.
         */
        fun engine(engine: String): FluentBuilder
        /**
         * The engine version of an instance.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * The license model for an instance.
         */
        fun licenseModel(licenseModel: String): FluentBuilder
        /**
         * Indicates whether an instance is in a virtual private cloud (VPC).
         */
        fun vpc(vpc: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of Availability Zones for an instance.
         */
        var availabilityZones: List<AvailabilityZone>?
        /**
         * The instance class for an instance.
         */
        var dbInstanceClass: String?
        /**
         * The engine type of an instance.
         */
        var engine: String?
        /**
         * The engine version of an instance.
         */
        var engineVersion: String?
        /**
         * The license model for an instance.
         */
        var licenseModel: String?
        /**
         * Indicates whether an instance is in a virtual private cloud (VPC).
         */
        var vpc: Boolean

        fun build(): OrderableDbInstanceOption
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZones: List<AvailabilityZone>? = null
        override var dbInstanceClass: String? = null
        override var engine: String? = null
        override var engineVersion: String? = null
        override var licenseModel: String? = null
        override var vpc: Boolean = false

        constructor(x: OrderableDbInstanceOption) : this() {
            this.availabilityZones = x.availabilityZones
            this.dbInstanceClass = x.dbInstanceClass
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.licenseModel = x.licenseModel
            this.vpc = x.vpc
        }

        override fun build(): OrderableDbInstanceOption = OrderableDbInstanceOption(this)
        override fun availabilityZones(availabilityZones: List<AvailabilityZone>): FluentBuilder = apply { this.availabilityZones = availabilityZones }
        override fun dbInstanceClass(dbInstanceClass: String): FluentBuilder = apply { this.dbInstanceClass = dbInstanceClass }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun licenseModel(licenseModel: String): FluentBuilder = apply { this.licenseModel = licenseModel }
        override fun vpc(vpc: Boolean): FluentBuilder = apply { this.vpc = vpc }
    }
}
