// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to ModifyGlobalCluster.
 */
class ModifyGlobalClusterRequest private constructor(builder: BuilderImpl) {
    /**
     * Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when deletion protection is enabled.
     */
    val deletionProtection: Boolean? = builder.deletionProtection
    /**
     * The identifier for the global cluster being modified. This parameter isn't case-sensitive.
     * Constraints:
     * Must match the identifier of an existing global cluster.
     */
    val globalClusterIdentifier: String? = builder.globalClusterIdentifier
    /**
     * The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase string.
     * Must contain from 1 to 63 letters, numbers, or hyphens
     * The first character must be a letter
     * Can't end with a hyphen or contain two consecutive hyphens
     * Example: my-cluster2
     */
    val newGlobalClusterIdentifier: String? = builder.newGlobalClusterIdentifier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyGlobalClusterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyGlobalClusterRequest(")
        append("deletionProtection=$deletionProtection,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("newGlobalClusterIdentifier=$newGlobalClusterIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletionProtection?.hashCode() ?: 0
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (newGlobalClusterIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyGlobalClusterRequest

        if (deletionProtection != other.deletionProtection) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (newGlobalClusterIdentifier != other.newGlobalClusterIdentifier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyGlobalClusterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyGlobalClusterRequest
        /**
         * Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when deletion protection is enabled.
         */
        fun deletionProtection(deletionProtection: Boolean): FluentBuilder
        /**
         * The identifier for the global cluster being modified. This parameter isn't case-sensitive.
         * Constraints:
         * Must match the identifier of an existing global cluster.
         */
        fun globalClusterIdentifier(globalClusterIdentifier: String): FluentBuilder
        /**
         * The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase string.
         * Must contain from 1 to 63 letters, numbers, or hyphens
         * The first character must be a letter
         * Can't end with a hyphen or contain two consecutive hyphens
         * Example: my-cluster2
         */
        fun newGlobalClusterIdentifier(newGlobalClusterIdentifier: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates if the global cluster has deletion protection enabled. The global cluster can't be deleted when deletion protection is enabled.
         */
        var deletionProtection: Boolean?
        /**
         * The identifier for the global cluster being modified. This parameter isn't case-sensitive.
         * Constraints:
         * Must match the identifier of an existing global cluster.
         */
        var globalClusterIdentifier: String?
        /**
         * The new identifier for a global cluster when you modify a global cluster. This value is stored as a lowercase string.
         * Must contain from 1 to 63 letters, numbers, or hyphens
         * The first character must be a letter
         * Can't end with a hyphen or contain two consecutive hyphens
         * Example: my-cluster2
         */
        var newGlobalClusterIdentifier: String?

        fun build(): ModifyGlobalClusterRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deletionProtection: Boolean? = null
        override var globalClusterIdentifier: String? = null
        override var newGlobalClusterIdentifier: String? = null

        constructor(x: ModifyGlobalClusterRequest) : this() {
            this.deletionProtection = x.deletionProtection
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.newGlobalClusterIdentifier = x.newGlobalClusterIdentifier
        }

        override fun build(): ModifyGlobalClusterRequest = ModifyGlobalClusterRequest(this)
        override fun deletionProtection(deletionProtection: Boolean): FluentBuilder = apply { this.deletionProtection = deletionProtection }
        override fun globalClusterIdentifier(globalClusterIdentifier: String): FluentBuilder = apply { this.globalClusterIdentifier = globalClusterIdentifier }
        override fun newGlobalClusterIdentifier(newGlobalClusterIdentifier: String): FluentBuilder = apply { this.newGlobalClusterIdentifier = newGlobalClusterIdentifier }
    }
}
