// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to ModifyEventSubscription.
 */
class ModifyEventSubscriptionRequest private constructor(builder: BuilderImpl) {
    /**
     * A Boolean value; set to true to activate the subscription.
     */
    val enabled: Boolean? = builder.enabled
    /**
     * A list of event categories for a SourceType that you want to subscribe
     * to.
     */
    val eventCategories: List<String>? = builder.eventCategories
    /**
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The
     * ARN is created by Amazon SNS when you create a topic and subscribe to it.
     */
    val snsTopicArn: String? = builder.snsTopicArn
    /**
     * The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, set this parameter to db-instance. If this value is not specified, all events are returned.
     * Valid values: db-instance, db-parameter-group, db-security-group
     */
    val sourceType: String? = builder.sourceType
    /**
     * The name of the Amazon DocumentDB event notification subscription.
     */
    val subscriptionName: String? = builder.subscriptionName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyEventSubscriptionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyEventSubscriptionRequest(")
        append("enabled=$enabled,")
        append("eventCategories=$eventCategories,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceType=$sourceType,")
        append("subscriptionName=$subscriptionName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (subscriptionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyEventSubscriptionRequest

        if (enabled != other.enabled) return false
        if (eventCategories != other.eventCategories) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceType != other.sourceType) return false
        if (subscriptionName != other.subscriptionName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyEventSubscriptionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyEventSubscriptionRequest
        /**
         * A Boolean value; set to true to activate the subscription.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * A list of event categories for a SourceType that you want to subscribe
         * to.
         */
        fun eventCategories(eventCategories: List<String>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The
         * ARN is created by Amazon SNS when you create a topic and subscribe to it.
         */
        fun snsTopicArn(snsTopicArn: String): FluentBuilder
        /**
         * The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, set this parameter to db-instance. If this value is not specified, all events are returned.
         * Valid values: db-instance, db-parameter-group, db-security-group
         */
        fun sourceType(sourceType: String): FluentBuilder
        /**
         * The name of the Amazon DocumentDB event notification subscription.
         */
        fun subscriptionName(subscriptionName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A Boolean value; set to true to activate the subscription.
         */
        var enabled: Boolean?
        /**
         * A list of event categories for a SourceType that you want to subscribe
         * to.
         */
        var eventCategories: List<String>?
        /**
         * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The
         * ARN is created by Amazon SNS when you create a topic and subscribe to it.
         */
        var snsTopicArn: String?
        /**
         * The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, set this parameter to db-instance. If this value is not specified, all events are returned.
         * Valid values: db-instance, db-parameter-group, db-security-group
         */
        var sourceType: String?
        /**
         * The name of the Amazon DocumentDB event notification subscription.
         */
        var subscriptionName: String?

        fun build(): ModifyEventSubscriptionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var enabled: Boolean? = null
        override var eventCategories: List<String>? = null
        override var snsTopicArn: String? = null
        override var sourceType: String? = null
        override var subscriptionName: String? = null

        constructor(x: ModifyEventSubscriptionRequest) : this() {
            this.enabled = x.enabled
            this.eventCategories = x.eventCategories
            this.snsTopicArn = x.snsTopicArn
            this.sourceType = x.sourceType
            this.subscriptionName = x.subscriptionName
        }

        override fun build(): ModifyEventSubscriptionRequest = ModifyEventSubscriptionRequest(this)
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun eventCategories(eventCategories: List<String>): FluentBuilder = apply { this.eventCategories = eventCategories }
        override fun snsTopicArn(snsTopicArn: String): FluentBuilder = apply { this.snsTopicArn = snsTopicArn }
        override fun sourceType(sourceType: String): FluentBuilder = apply { this.sourceType = sourceType }
        override fun subscriptionName(subscriptionName: String): FluentBuilder = apply { this.subscriptionName = subscriptionName }
    }
}
